<?php
include 'functions.php';
session_start();

try {
  $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  ]);
} catch (Exception $e) {
  die("Erreur DB : " . $e->getMessage());
}

$id = $_GET['id'] ?? '';
$id = (int)$id; // Convertir en entier pour éviter les injections

if ($id <= 0) {
  die("ID d'invitation manquant ou invalide.");
}

// Chercher invité par id
$stmt = $pdo->prepare("SELECT * FROM invites WHERE id = ?");
$stmt->execute([$id]);
$invite = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$invite) {
  die("Invitation invalide.");
}

$message = '';

// Traitement de la confirmation d'entrée
if (isset($_POST['confirm'])) {
  if ($invite['status'] !== 'Présent dans la salle') {
    $isCouple = (strtolower($invite['type_invitation']) === 'couple');
    
    // Récupérer le nombre de personnes présentes
    $nombre_personnes = 1; // Par défaut
    if ($isCouple) {
      $nombre_personnes = isset($_POST['nombre_personnes']) ? (int)$_POST['nombre_personnes'] : 2;
    }
    
    $upd = $pdo->prepare("UPDATE invites SET status = 'Présent dans la salle', nombre_personnes_presentes = ? WHERE id = ?");
    $upd->execute([$nombre_personnes, $invite['id']]);
    
    $message = "Entrée confirmée. Bienvenue!";
    $invite['status'] = 'Présent dans la salle';
    $invite['nombre_personnes_presentes'] = $nombre_personnes;
  } else {
    $message = "Cet invité est déjà enregistré.";
  }
}

// Déterminer si c'est un couple ou un célibataire
$isCouple = (strtolower($invite['type_invitation']) === 'couple');

// Récupérer tous les invités de la même table
$stmtTable = $pdo->prepare("SELECT * FROM invites WHERE table_num = ? ORDER BY nom ASC");
$stmtTable->execute([$invite['table_num']]);
$invitesTable = $stmtTable->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Vérification Invitation</title>
  <link rel="apple-touch-icon" sizes="180x180" href="favicon_io/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="favicon_io/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="favicon_io/favicon-16x16.png">
  <link rel="manifest" href="favicon_io/site.webmanifest">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.css" rel="stylesheet" />
  <style>
    body {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
    }
    .container {
      background: white;
      border-radius: 15px;
      box-shadow: 0 10px 40px rgba(0,0,0,0.2);
      padding: 20px;
      margin-top: 20px;
      margin-bottom: 20px;
    }
    .table-guest {
      background-color: #f8f9fa;
      border-left: 4px solid #0d6efd;
      padding: 15px;
      margin-bottom: 10px;
      border-radius: 5px;
      transition: all 0.3s ease;
    }
    .table-guest:hover {
      transform: translateX(5px);
      box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .table-guest.present {
      border-left-color: #198754;
      background-color: #d1e7dd;
    }
    .table-guest.current {
      border-left-color: #ffc107;
      background-color: #fff3cd;
    }
    .gold-badge {
      background: linear-gradient(135deg, #d4af37 0%, #f9d77e 100%);
      color: #000;
      padding: 8px 20px;
      border-radius: 25px;
      font-size: 1rem;
      font-weight: bold;
      display: inline-block;
      margin-bottom: 15px;
    }
  </style>
</head>

<body class="p-4">
  <div class="container" style="max-width: 580px;">
    <nav class="navbar navbar-expand navbar-light">
      <div class="container">
        <div class="row text-center w-100">
          <a class="navbar-brand mx-auto" href="#">
            <img src="images/ChatGPT 6'.png" alt="" style="max-width: 250px;">
          </a>
        </div>
      </div>
    </nav>

    <h1 class="text-center" style="text-shadow: 0 1px 3px rgba(0,0,0,0.2);">Vérification d'invitation</h1>
    <hr>
    
    <?php if ($message): ?>
      <div class="alert alert-success">
        <i class="bi bi-check-circle-fill"></i> <?= htmlspecialchars($message) ?>
      </div>
      <script>
        // Attendre que la page soit chargée avant d'afficher les confettis
        if (document.readyState === 'loading') {
          document.addEventListener('DOMContentLoaded', function() {
            createConfetti();
          });
        } else {
          createConfetti();
        }

        function createConfetti() {
            // Palette de couleurs du mariage : doré, beige, marron clair
            const colors = ['#d4a574', '#8b6f47', '#e7c04d', '#f3d89c', '#c19a6b'];
            
            for (let i = 0; i < 40; i++) {
                const confetti = document.createElement('div');
                confetti.style.position = 'fixed';
                confetti.style.left = Math.random() * 100 + 'vw';
                confetti.style.top = '-10px';
                confetti.style.width = `${Math.random() * 8 + 6}px`;
                confetti.style.height = `${Math.random() * 8 + 6}px`;
                confetti.style.zIndex = '9999';
                confetti.style.pointerEvents = 'none';
                confetti.style.opacity = '0.9';
                confetti.style.fontSize = '10px';
                confetti.style.fontFamily = "'Playfair Display', 'Great Vibes', serif";
                confetti.style.color = colors[Math.floor(Math.random() * colors.length)];
                confetti.style.display = 'flex';
                confetti.style.alignItems = 'center';
                confetti.style.justifyContent = 'center';
                confetti.style.textAlign = 'center';

                // Alternance subtile entre cœur et "A & P"
                if (Math.random() > 0.5) {
                    // Cœur doré, fin et élégant
                    confetti.style.clipPath = 'polygon(50% 0%, 61% 35%, 98% 35%, 68% 57%, 79% 91%, 50% 70%, 21% 91%, 32% 57%, 2% 35%, 39% 35%)';
                    confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
                } else {
                    // Texte "A & P" avec police élégante
                    confetti.style.backgroundColor = 'transparent';
                    confetti.textContent = 'A & P';
                    confetti.style.fontWeight = 'normal';
                    confetti.style.letterSpacing = '0.5px';
                }

                document.body.appendChild(confetti);

                // Animation douce et naturelle
                const animation = confetti.animate([
                    { transform: 'translateY(0) rotate(0deg)', opacity: 1 },
                    { transform: `translateY(${window.innerHeight}px) rotate(${Math.random() * 720}deg)`, opacity: 0 }
                ], {
                    duration: 7000 + Math.random() * 5000,
                    easing: 'cubic-bezier(0.2, 0.8, 0.3, 1)',
                    delay: Math.random() * 500
                });

                animation.onfinish = () => confetti.remove();
            }
        }
      </script>
    <?php endif; ?>
    
    <div class="text-center">
      <h2><strong>TABLE</strong> <span class="text-primary"><?= toRomanNumeral($invite['table_num']) ?></span>
      </h2>
      <small>(<?= htmlspecialchars($invite['table_num']) ?>)</small>
    </div>
    
    <div class="text-center my-4">
      <img src="images/ChatGPT 9.png" alt="Logo" style="max-width: 250px;">
    </div>
    
    <div class="text-center mb-3">
      <span class="gold-badge">
        <?= $isCouple ? '👫 Couple invité' : '👤 Invité(e)' ?>
      </span>
    </div>
    
    <div class="card mb-4">
      <div class="card-body">
        <h5 class="card-title">Informations de l'invité(e)</h5>
        <hr>
        
        <?php if ($isCouple): ?>
          <!-- Affichage pour un couple -->
          <div class="row mb-3">
            <div class="col-12">
              <p class="mb-2"><strong><?= htmlspecialchars($invite['titre1']) ?> :</strong> <?= htmlspecialchars($invite['nom']) ?></p>
              <p class="mb-2"><strong><?= htmlspecialchars($invite['titre2']) ?> :</strong> <?= htmlspecialchars($invite['nom2']) ?></p>
            </div>
          </div>
        <?php else: ?>
          <!-- Affichage pour une personne seule -->
          <p><strong><?= htmlspecialchars($invite['titre1']) ?> :</strong> <?= htmlspecialchars($invite['nom']) ?></p>
        <?php endif; ?>
        
        <p><strong><i class="bi bi-envelope"></i> Email :</strong> <?= htmlspecialchars($invite['email']) ?></p>
        <p><strong><i class="bi bi-telephone"></i> Téléphone :</strong> N/A</p>
        <p><strong><i class="bi bi-table"></i> Table :</strong> <?= htmlspecialchars($invite['table_num']) ?></p>
        
        <p><strong><i class="bi bi-clipboard-check"></i> Statut :</strong>
          <?php if ($invite['status'] === 'Présent dans la salle'): ?>
            <span class="badge bg-success">✓ Entrée VALIDée</span>
          <?php elseif ($invite['status'] === 'A confirmé'): ?>
            <span class="badge bg-warning text-dark">⏳ Présence Confirmée</span>
          <?php else: ?>
            <span class="badge bg-secondary">⏸ En attente de confirmation</span>
          <?php endif; ?>
        </p>
        
        <?php if ($invite['status'] === 'Présent dans la salle' && $invite['nombre_personnes_presentes']): ?>
          <p><strong><i class="bi bi-people"></i> Personnes présentes :</strong> 
            <span class="badge bg-info"><?= htmlspecialchars($invite['nombre_personnes_presentes']) ?> personne(s)</span>
          </p>
        <?php endif; ?>
        
        <?php if (!empty($invite['message_maries'])): ?>
          <div class="alert alert-light mt-3">
            <strong><i class="bi bi-heart-fill text-danger"></i> Message pour les mariés :</strong><br>
            <em>"<?= htmlspecialchars($invite['message_maries']) ?>"</em>
          </div>
        <?php endif; ?>
      </div>
    </div>
    
    <?php if ($invite['status'] !== 'Présent dans la salle'): ?>
      <div class="card mb-4">
        <div class="card-body">
          <h5 class="card-title"><i class="bi bi-check-circle"></i> Confirmer l'entrée</h5>
          <form method="POST">
            <?php if ($isCouple): ?>
              <div class="mb-3">
                <label class="form-label"><strong>Nombre de personnes présentes :</strong></label>
                <div class="form-check">
                  <input class="form-check-input" type="radio" name="nombre_personnes" id="nb2" value="2" checked>
                  <label class="form-check-label" for="nb2">
                    <strong>2 personnes</strong> - Le couple complet (<?= htmlspecialchars($invite['titre1']) ?> & <?= htmlspecialchars($invite['titre2']) ?>)
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" name="nombre_personnes" id="nb1" value="1">
                  <label class="form-check-label" for="nb1">
                    <strong>1 personne</strong> - Seulement <?= htmlspecialchars($invite['titre1']) ?> ou <?= htmlspecialchars($invite['titre2']) ?>
                  </label>
                </div>
              </div>
            <?php endif; ?>
            
            <button type="submit" name="confirm" class="btn btn-success w-100 btn-lg">
              <i class="bi bi-check-circle"></i> Confirmer l'entrée
            </button>
          </form>
        </div>
      </div>
    <?php else: ?>
      <div class="alert alert-success">
        <i class="bi bi-check-circle-fill"></i> <strong>Entrée déjà enregistrée.</strong>
      </div>
    <?php endif; ?>

    <!-- Section des invités de la même table -->
    <div class="mt-5">
      <h3><i class="bi bi-people-fill"></i> Invités de la table <?= htmlspecialchars($invite['table_num']) ?></h3>
      <hr>
      <p class="text-muted small">
        <span class="badge bg-success">●</span> Présent dans la salle &nbsp;
        <span class="badge bg-warning text-dark">●</span> Confirmé &nbsp;
        <span class="badge bg-secondary">●</span> En attente
      </p>

      <?php foreach ($invitesTable as $guest): ?>
        <?php 
          $isCoupleGuest = (strtolower($guest['type_invitation']) === 'couple');
          $isCurrent = ($guest['id'] === $invite['id']);
          $isPresent = ($guest['status'] === 'Présent dans la salle');
          
          $cssClass = 'table-guest';
          if ($isCurrent) {
            $cssClass .= ' current';
          } elseif ($isPresent) {
            $cssClass .= ' present';
          }
        ?>
        
        <div class="<?= $cssClass ?>">
          <?php if ($isCoupleGuest): ?>
            <!-- Couple -->
            <div>
              <strong>👫 Couple:</strong>
              <div class="ms-3">
                <?= htmlspecialchars($guest['titre1']) ?> <?= htmlspecialchars($guest['nom']) ?>
                <br>
                <?= htmlspecialchars($guest['titre2']) ?> <?= htmlspecialchars($guest['nom2']) ?>
              </div>
            </div>
          <?php else: ?>
            <!-- Single -->
            <div>
              <strong>👤 <?= htmlspecialchars($guest['titre1']) ?></strong> <?= htmlspecialchars($guest['nom']) ?>
            </div>
          <?php endif; ?>
          
          <div class="mt-2">
            <small>
              <?php if ($guest['status'] === 'Présent dans la salle'): ?>
                <span class="badge bg-success">✓ Présent dans la salle</span>
                <?php if ($guest['nombre_personnes_presentes']): ?>
                  <span class="badge bg-info"><?= $guest['nombre_personnes_presentes'] ?> pers.</span>
                <?php endif; ?>
              <?php elseif ($guest['status'] === 'A confirmé'): ?>
                <span class="badge bg-warning text-dark">⏳ Confirmé</span>
              <?php else: ?>
                <span class="badge bg-secondary">⏸ En attente</span>
              <?php endif; ?>
              
              <?php if ($isCurrent): ?>
                <span class="badge bg-warning text-dark ms-1">← Invité actuel</span>
              <?php endif; ?>
            </small>
          </div>
        </div>
      <?php endforeach; ?>

      <?php 
        // Statistiques de la table
        $totalGuests = count($invitesTable);
        $presentGuests = count(array_filter($invitesTable, function($g) {
          return $g['status'] === 'Présent dans la salle';
        }));
        
        // Compter le nombre réel de personnes physiques présentes
        $totalPersonnesPhysiques = array_sum(array_map(function($g) {
          return ($g['status'] === 'Présent dans la salle' && $g['nombre_personnes_presentes']) 
            ? (int)$g['nombre_personnes_presentes'] 
            : 0;
        }, $invitesTable));
      ?>
      
      <div class="alert alert-info mt-3">
        <strong><i class="bi bi-graph-up"></i> Total table <?= htmlspecialchars($invite['table_num']) ?> :</strong> 
        <?= $presentGuests ?> / <?= $totalGuests ?> invité(s) arrivé(s)
        <?php if ($totalPersonnesPhysiques > 0): ?>
          <br><small class="text-muted">(<?= $totalPersonnesPhysiques ?> personne(s) physique(s) présente(s) dans la salle)</small>
        <?php endif; ?>
      </div>
    </div>

  </div>
  
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>