<?php
// validation.php

$host = 'localhost';
$dbname = 'tostrlgj_mariage_db';
$user = 'tostrlgj_voldy';
$pass = 'Voldy25@Ilus';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (Exception $e) {
    die("Erreur DB : " . $e->getMessage());
}

$invitation = null;
$error = null;
$successMsg = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['invitation_id'] ?? 0);
    if ($id > 0) {
        $stmt = $pdo->prepare("SELECT * FROM invites WHERE id = ?");
        $stmt->execute([$id]);
        $invitation = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$invitation) {
            $error = "Invitation non trouvée.";
        } else {
            if ($invitation['status'] === 'Présent dans la salle') {
                $error = "Cette invitation a déjà été validée.";
            } else {
                // Marquer comme validée
                $update = $pdo->prepare("UPDATE invites SET status = 1 WHERE id = ?");
                $update->execute([$id]);
                $successMsg = "Invitation validée avec succès !";
                // Recharger les données pour afficher le statut à jour
                $invitation['status'] = 'Présent dans la salle';
            }
        }
    } else {
        $error = "ID d'invitation invalide.";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <title>Validation Invitation</title>
  <link rel="apple-touch-icon" sizes="180x180" href="favicon_io/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon_io/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon_io/favicon-16x16.png">
<link rel="manifest" href="favicon_io/site.webmanifest">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body { padding: 2rem; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #f7f9fc; }
  </style>
</head>
<body>
  <div class="container" style="max-width: 600px;">
    <h1 class="mb-4 text-center text-primary" style="text-shadow: 0 1px 3px rgba(0,0,0,0.2);">Validation d'invitation</h1>

    <form method="POST" class="mb-4">
      <div class="input-group">
        <input type="number" name="invitation_id" class="form-control" placeholder="Entrez l'ID d'invitation (ex: 1)" required />
        <button class="btn btn-primary" type="submit">Valider</button>
      </div>
    </form>

    <?php if ($error): ?>
      <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <?php if ($successMsg): ?>
      <div class="alert alert-success"><?= htmlspecialchars($successMsg) ?></div>
    <?php endif; ?>

    <?php if ($invitation): ?>
      <div class="card border-primary mb-3">
        <div class="card-header">Invitation <?= $invitation['status'] ? 'validée' : 'non validée' ?></div>
        <div class="card-body">
          <h5 class="card-title"><?= htmlspecialchars($invitation['nom']) ?></h5>
          <p class="card-text"><strong>Email :</strong> <?= htmlspecialchars($invitation['email']) ?></p>
          <p class="card-text"><strong>Téléphone :</strong> <?= htmlspecialchars($invitation['telephone']) ?></p>
          <p class="card-text"><strong>Code / Référence :</strong> <?= htmlspecialchars($invitation['code_invitation']) ?></p>
          <p class="card-text"><strong>Table assignée :</strong> <?= htmlspecialchars($invitation['table_num']) ?></p>
          <p class="card-text"><small class="text-muted">Invité enregistré le <?= htmlspecialchars($invitation['date_created']) ?></small></p>
        </div>
      </div>
    <?php endif; ?>
  </div>
</body>
</html>
