<?php
// Connexion à la base de données
try {
    $pdo = new PDO("mysql:host=localhost;dbname=mariage_db;charset=utf8mb4", "root", "", [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (Exception $e) {
    die("Erreur DB : " . $e->getMessage());
}

// Récupérer l'id de l'invité depuis l'URL
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("ID invalide");
}

$inviteId = (int) $_GET['id'];

// Requête pour récupérer les infos de l'invité
$stmt = $pdo->prepare("SELECT nom, email, telephone, code_invitation FROM invites WHERE id = ?");
$stmt->execute([$inviteId]);
$invite = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$invite) {
    die("Invité non trouvé");
}

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Invitation de <?php echo htmlspecialchars($invite['nom']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
    <div class="container mt-5">
        <h1>Invitation de <?php echo htmlspecialchars($invite['nom']); ?></h1>
        <p><strong>Email :</strong> <?php echo htmlspecialchars($invite['email']); ?></p>
        <p><strong>Téléphone :</strong> <?php echo htmlspecialchars($invite['telephone']); ?></p>
        <p><strong>Code / Référence :</strong> <?php echo htmlspecialchars($invite['code_invitation']); ?></p>
        <!-- Tu peux aussi afficher d’autres infos ou ajouter un QR code si tu veux -->
    </div>
</body>
</html>
