<?php
session_start();

// Inclure la librairie PHP QR Code
require_once __DIR__ . '/lib/qrlib.php';

// Connexion PDO (adapter tes infos)
try {
    $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", "tostrlgj_voldy", "Voldy25@Ilus", [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (Exception $e) {
    die("Erreur DB : " . $e->getMessage());
}

// Récupérer et valider les données POST
$fullName = trim($_POST['nom'] ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['telephone'] ?? '');
$codeRef = trim($_POST['code_invitation'] ?? '');

// Simple validation
$errors = [];
if ($fullName === '') $errors[] = "Le nom complet est obligatoire.";
if ($email === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "Email invalide.";

// Si erreur, afficher (simple)
if ($errors) {
    foreach ($errors as $error) {
        echo "<p style='color:red;'>$error</p>";
    }
    echo "<p><a href='javascript:history.back()'>Retour</a></p>";
    exit;
}

// Stocker en base (exemple simplifié)
$stmt = $pdo->prepare("INSERT INTO invites (nom, email, telephone, code_invitation) VALUES (?, ?, ?, ?)");
$stmt->execute([$fullName, $email, $phone, $codeRef]);

$inviteId = $pdo->lastInsertId();

// Construire les données pour le QR code (ici on encode juste un lien vers l'invitation)
$qrData = "https://vkiz-digital.website/aaronandprincillia/invitation_process.php?id=" . $inviteId;

// Générer le QR code dans un fichier temporaire
$qrTempFile = __DIR__ . "/qr_codes/qr_invite_$inviteId.png";
if (!file_exists(__DIR__ . "/qr_codes")) {
    mkdir(__DIR__ . "/qr_codes", 0777, true);
}
QRcode::png($qrData, $qrTempFile, QR_ECLEVEL_L, 4);

// Afficher la page invitation complète
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <title>Votre invitation</title>
  <link rel="apple-touch-icon" sizes="180x180" href="favicon_io/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon_io/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon_io/favicon-16x16.png">
<link rel="manifest" href="favicon_io/site.webmanifest">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body { font-family: Arial, sans-serif; padding: 2rem; background: #f7f9fc; }
    .invitation-container { max-width: 500px; margin: auto; background: white; padding: 1.5rem; border: 2px solid #0d6efd; border-radius: 10px; text-align: center; }
    .qr-code { margin: 1rem auto; }
  </style>
</head>
<body>
  <div class="invitation-container">
    <h1 class="text-primary" style="text-shadow: 0 1px 3px rgba(0,0,0,0.2);">Votre invitation</h1>
    <img src="<?php echo "qr_codes/qr_invite_$inviteId.png"; ?>" alt="QR Code" class="qr-code" />
    <p><strong>Nom complet :</strong> <?php echo htmlspecialchars($fullName); ?></p>
    <p><strong>Table assignée :</strong> <?php 
      // Exemple simple d'assignation selon le codeRef
      $tableMap = [
        "VIP123" => "Table VIP",
        "AMIS456" => "Table des amis",
        "FAMILLE789" => "Table Famille",
      ];
      echo $codeRef && isset($tableMap[$codeRef]) ? $tableMap[$codeRef] : "À définir à l'entrée";
    ?></p>

    <button onclick="window.print()" class="btn btn-outline-primary mt-3">
      <i class="bi bi-printer"></i> Télécharger / Imprimer
    </button>
  </div>
</body>
</html>
