<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'functions.php';
define('UPLOADS_URL', 'uploads/');
// 🔌 Une seule connexion PDO pour tout le fichier
try {
    $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (Exception $e) {
    die("Erreur de connexion à la base de données : " . htmlspecialchars($e->getMessage()));
}
?>


<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="../favicon_io/favicon.ico" type="image/x-icon" />
    <title>Notre mariage : Aaron & Princillia</title>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700;900&family=Lora:wght@400;500;600&family=Montserrat:wght@300;400;500;600&family=Great+Vibes:wght@400&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Lora', serif;
            color: #2c2c2c;
            background: #fafaf8;
            overflow-x: hidden;
        }

        /* Navigation */
        .navbar {
            position: fixed;
            top: 0;
            width: 100%;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 1rem 2rem;
            z-index: 1000;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.05);
        }

        .logo-text {
            font-family: 'Playfair Display', serif;
            font-size: 1.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .nav-links {
            display: flex;
            gap: 3rem;
            list-style: none;
        }

        .nav-links a {
            font-family: 'Montserrat', sans-serif;
            font-size: 0.95rem;
            font-weight: 500;
            color: #2c2c2c;
            text-decoration: none;
            position: relative;
            transition: color 0.3s ease;
        }

        .nav-links a::after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 0;
            height: 2px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            transition: width 0.3s ease;
        }

        .nav-links a:hover {
            color: #d4a574;
        }

        .nav-links a:hover::after {
            width: 100%;
        }

        /* Hero Section */
        .hero {
            margin-top: 80px;
            height: 100vh;
            position: relative;
            background: linear-gradient(135deg, #1a1a1a 0%, #2c2c2c 100%);
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .hero::before {
            content: '';
            position: absolute;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(212, 165, 116, 0.15) 0%, transparent 70%);
            top: -200px;
            right: -200px;
            animation: float 8s ease-in-out infinite;
        }

        .hero::after {
            content: '';
            position: absolute;
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, rgba(212, 165, 116, 0.1) 0%, transparent 70%);
            bottom: -150px;
            left: -150px;
            animation: float 10s ease-in-out infinite reverse;
        }

        /* Carousel Styles */
        .carousel-wrapper {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
        }

        .carousel-slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1.5s ease-in-out;
        }

        .carousel-slide.active {
            opacity: 0.3;
        }

        .carousel-slide img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .carousel-controls {
            position: absolute;
            bottom: 30px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 15px;
            z-index: 10;
        }

        .carousel-dot {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.4);
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }

        .carousel-dot.active {
            background: #d4a574;
            width: 30px;
            border-radius: 6px;
        }

        @keyframes float {

            0%,
            100% {
                transform: translateY(0px);
            }

            50% {
                transform: translateY(30px);
            }
        }

        .hero-content {
            position: relative;
            z-index: 2;
            text-align: center;
            color: white;
            max-width: 900px;
            padding: 0 2rem;
        }

        .hero-subtitle {
            font-family: 'Montserrat', sans-serif;
            font-size: 1rem;
            letter-spacing: 3px;
            color: #d4a574;
            margin-bottom: 1rem;
            text-transform: uppercase;
            font-weight: 500;
        }

        .hero-title {
            font-family: 'Playfair Display', serif;
            font-size: 5rem;
            font-weight: 900;
            margin-bottom: 1rem;
            line-height: 1.1;
        }

        .hero-names {
            font-family: 'Great Vibes', cursive;
            font-size: 5rem;
            margin: 1.5rem 0;
            background: linear-gradient(135deg, #d4a574 0%, #c99961 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-weight: 400;
            letter-spacing: 2px;
        }

        .hero-quote {
            font-family: 'Lora', serif;
            font-size: 1.2rem;
            font-style: italic;
            color: #bbb;
            margin: 2rem 0;
            line-height: 1.8;
        }

        .cta-button {
            display: inline-block;
            margin-top: 2rem;
            padding: 1rem 3rem;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            text-decoration: none;
            font-family: 'Montserrat', sans-serif;
            font-weight: 600;
            border-radius: 50px;
            transition: all 0.3s ease;
            box-shadow: 0 10px 30px rgba(212, 165, 116, 0.3);
            border: none;
            cursor: pointer;
            letter-spacing: 1px;
        }

        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(212, 165, 116, 0.4);
        }

        /* Countdown Section */
        .countdown-section {
            padding: 4rem 2rem;
            background: linear-gradient(135deg, #2c2c2c 0%, #1a1a1a 100%);
            text-align: center;
        }

        .countdown-title {
            font-family: 'Playfair Display', serif;
            font-size: 2.5rem;
            color: white;
            margin-bottom: 2rem;
        }

        .countdown {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 1.5rem;
            max-width: 800px;
            margin: 0 auto;
        }

        .countdown-item {
            background: rgba(212, 165, 116, 0.1);
            border: 2px solid #d4a574;
            border-radius: 15px;
            padding: 1.5rem;
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease;
        }

        .countdown-item:hover {
            transform: scale(1.05);
        }

        .countdown-number {
            font-family: 'Playfair Display', serif;
            font-size: 2.5rem;
            font-weight: 900;
            color: #d4a574;
        }

        .countdown-label {
            font-family: 'Montserrat', sans-serif;
            font-size: 0.85rem;
            color: #bbb;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-top: 0.5rem;
        }

        /* Couple Section */
        .couple-section {
            padding: 6rem 2rem;
            background: white;
            position: relative;
        }

        .section-title {
            font-family: 'Playfair Display', serif;
            font-size: 3.5rem;
            text-align: center;
            margin-bottom: 4rem;
            color: #2c2c2c;
            position: relative;
        }

        .section-title::after {
            content: '';
            position: absolute;
            width: 60px;
            height: 3px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            left: 50%;
            transform: translateX(-50%);
            bottom: -20px;
        }

        .couple-grid {
            display: grid;
            grid-template-columns: 1fr auto 1fr;
            gap: 3rem;
            align-items: center;
            margin-top: 3rem;
        }

        .couple-card {
            text-align: center;
        }

        .couple-image {
            width: 280px;
            height: 380px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            border-radius: 20px;
            overflow: hidden;
            margin: 0 auto 2rem;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            transition: transform 0.3s ease;
        }

        .couple-image:hover {
            transform: translateY(-10px);
        }

        .couple-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .couple-name {
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            color: #d4a574;
            margin-bottom: 1rem;
        }

        .couple-bio {
            color: #666;
            line-height: 1.8;
            font-size: 1rem;
        }

        .heart-divider {
            font-size: 3rem;
            color: #d4a574;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100%;
        }

        /* Story Section */
        .story-section {
            padding: 6rem 2rem;
            background: linear-gradient(135deg, #f5f5f2 0%, #e8e6e1 100%);
            position: relative;
        }

        .story-content {
            max-width: 900px;
            margin: 0 auto;
            text-align: center;
        }

        .story-text {
            font-size: 1.3rem;
            line-height: 2;
            color: #2c2c2c;
            margin: 2rem 0;
            font-weight: 500;
        }

        /* Pagne Section */
        .pagne-section {
            padding: 6rem 2rem;
            background: white;
        }

        .pagne-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .pagne-image {
            width: 100%;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        }

        .pagne-image img {
            width: 100%;
            height: auto;
            display: block;
        }

        .pagne-content h3 {
            font-family: 'Playfair Display', serif;
            font-size: 2.5rem;
            color: #d4a574;
            margin-bottom: 1.5rem;
        }

        .pagne-content p {
            font-size: 1.1rem;
            line-height: 1.9;
            color: #555;
            margin-bottom: 1.5rem;
        }

        /* Dress Code Section */
        .dress-code-section {
            padding: 6rem 2rem;
            background: linear-gradient(135deg, #f5f5f2 0%, #e8e6e1 100%);
        }

        .dress-code-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 3rem;
            margin-top: 3rem;
        }

        .dress-code-card {
            background: white;
            padding: 2.5rem;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease;
        }

        .dress-code-card:hover {
            transform: translateY(-5px);
        }

        .dress-code-icon {
            font-size: 3rem;
            color: #d4a574;
            margin-bottom: 1rem;
        }

        .dress-code-card h4 {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            color: #2c2c2c;
            margin-bottom: 1rem;
        }

        .dress-code-card ul {
            list-style: none;
            color: #666;
            line-height: 2;
        }

        .dress-code-card li::before {
            content: '✓ ';
            color: #d4a574;
            font-weight: bold;
            margin-right: 0.5rem;
        }

        /* Location Section */
        .location-section {
            padding: 6rem 2rem;
            background: white;
        }

        .location-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 4rem;
            align-items: center;
        }

        .location-info h3 {
            font-family: 'Playfair Display', serif;
            font-size: 2.5rem;
            color: #d4a574;
            margin-bottom: 2rem;
        }

        .location-details {
            background: #f5f5f2;
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 1.5rem;
        }

        .location-details p {
            font-size: 1.1rem;
            color: #555;
            margin: 0.5rem 0;
        }

        .location-label {
            font-weight: bold;
            color: #d4a574;
        }

        .map-container {
            width: 100%;
            height: 400px;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
        }

        .map-container iframe {
            width: 100%;
            height: 100%;
            border: none;
        }

        /* Events Teaser */
        .events-teaser {
            padding: 4rem 2rem;
            background: linear-gradient(135deg, #2c2c2c 0%, #1a1a1a 100%);
            text-align: center;
        }

        .events-teaser-title {
            font-family: 'Playfair Display', serif;
            font-size: 2.5rem;
            color: white;
            margin-bottom: 2rem;
        }

        .events-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            max-width: 1000px;
            margin: 0 auto;
        }

        .event-card {
            background: rgba(212, 165, 116, 0.1);
            border: 2px solid #d4a574;
            border-radius: 15px;
            padding: 2.5rem;
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease;
        }

        .event-card:hover {
            transform: translateY(-5px);
        }

        .event-card h4 {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            color: #d4a574;
            margin-bottom: 1rem;
        }

        .event-date {
            font-family: 'Montserrat', sans-serif;
            color: #bbb;
            font-size: 0.95rem;
            margin-bottom: 1rem;
        }

        .event-status {
            display: inline-block;
            padding: 0.5rem 1rem;
            background: #d4a574;
            color: white;
            border-radius: 50px;
            font-size: 0.85rem;
            font-weight: 600;
        }

        .event-status.coming {
            background: rgba(212, 165, 116, 0.3);
            color: #d4a574;
            border: 1px solid #d4a574;
        }

        /* Precious Moments Section */
        .moments-section {
            padding: 6rem 2rem;
            background: white;
        }

        .moments-carousel {
            position: relative;
            width: 100%;
            height: 500px;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 30px 80px rgba(0, 0, 0, 0.15);
            margin-top: 3rem;
        }

        .moment-slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }

        .moment-slide.active {
            opacity: 1;
        }

        .moment-slide img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .moment-slide-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(180deg, transparent 0%, rgba(0, 0, 0, 0.7) 100%);
            padding: 3rem 2rem;
            color: white;
        }

        .moment-title {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            margin-bottom: 0.5rem;
        }

        .moment-description {
            font-size: 1rem;
            opacity: 0.9;
        }

        .carousel-arrow {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 50px;
            height: 50px;
            background: rgba(212, 165, 116, 0.8);
            color: white;
            border: none;
            border-radius: 50%;
            font-size: 1.5rem;
            cursor: pointer;
            z-index: 20;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .carousel-arrow:hover {
            background: #d4a574;
            transform: translateY(-50%) scale(1.1);
        }

        .carousel-arrow.prev {
            left: 20px;
        }

        .carousel-arrow.next {
            right: 20px;
        }

        .moment-dots {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 10px;
            z-index: 20;
        }

        .moment-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.5);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .moment-dot.active {
            background: white;
            width: 30px;
            border-radius: 5px;
        }

        /* Footer */
        footer {
            background: #1a1a1a;
            color: white;
            text-align: center;
            padding: 2rem;
            font-family: 'Montserrat', sans-serif;
            font-size: 0.95rem;
        }

        footer a {
            color: #d4a574;
            text-decoration: none;
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }

            .hero-names {
                font-size: 3rem;
            }

            .hero-quote {
                font-size: 1rem;
            }

            .couple-grid {
                grid-template-columns: 1fr;
                gap: 2rem;
            }

            .heart-divider {
                margin: 2rem 0;
            }

            .section-title {
                font-size: 2rem;
            }

            .nav-links {
                gap: 1.5rem;
                font-size: 0.9rem;
            }

            .pagne-grid,
            .location-grid {
                grid-template-columns: 1fr;
            }

            .countdown {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        /* Pagne Carousel Section */
        .pagne-carousel-section {
            padding: 6rem 2rem;
            background: linear-gradient(135deg, #f5f5f2 0%, #e8e6e1 100%);
        }

        .pagne-carousel-wrapper {
            position: relative;
            width: 100%;
            height: 500px;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 30px 80px rgba(0, 0, 0, 0.15);
            margin-bottom: 3rem;
        }

        .pagne-slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }

        .pagne-slide.active {
            opacity: 1;
        }

        .pagne-slide img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /*  .pagne-slide img {
            z-index: 1;
            position: relative;
        } */

        .pagne-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: linear-gradient(180deg, transparent 0%, rgba(0, 0, 0, 0.8) 100%);
            padding: 3rem 2rem;
            color: white;
            z-index: 2;
        }

        .pagne-slide-title {
            font-family: 'Playfair Display', serif;
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            color: #d4a574;
        }

        .pagne-slide-description {
            font-size: 1rem;
            line-height: 1.6;
            opacity: 0.95;
        }

        .carousel-arrow {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 50px;
            height: 50px;
            background: rgba(212, 165, 116, 0.8);
            color: white;
            border: none;
            border-radius: 50%;
            font-size: 1.5rem;
            cursor: pointer;
            z-index: 20;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .carousel-arrow:hover {
            background: #d4a574;
            transform: translateY(-50%) scale(1.1);
        }

        .carousel-arrow.pagne-prev {
            left: 20px;
        }

        .carousel-arrow.pagne-next {
            right: 20px;
        }

        .pagne-dots {
            position: absolute;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 10px;
            z-index: 20;
        }

        .pagne-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.5);
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .pagne-dot.active {
            background: white;
            width: 30px;
            border-radius: 5px;
        }

        .pagne-info {
            background: white;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }

        .pagne-info p {
            color: #555;
            line-height: 1.8;
            margin-bottom: 1rem;
            font-size: 1rem;
        }

        .pagne-info p:last-child {
            margin-bottom: 0;
        }

        @media (max-width: 768px) {
            .pagne-carousel-wrapper {
                height: 350px;
            }

            .pagne-overlay {
                padding: 2rem 1rem;
            }

            .pagne-slide-title {
                font-size: 1.5rem;
            }

            .pagne-slide-description {
                font-size: 0.9rem;
            }
        }

        /* Guest Messages Section */
        .guest-messages-section {
            padding: 6rem 2rem;
            background: linear-gradient(135deg, #f5f5f2 0%, #e8e6e1 100%);
        }

        .messages-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 2rem;
            margin-top: 3rem;
        }

        .message-card {
            background: white;
            padding: 1.5rem;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            position: relative;
            font-family: 'Lora', serif;
        }

        .message-card::before {
            content: '❝';
            position: absolute;
            top: -20px;
            left: 20px;
            width: 40px;
            height: 40px;
            background: #d4a574;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-family: sans-serif;
            font-size: 1.2rem;
        }

        .message-card p {
            margin-top: 20px;
            color: #2c2c2c;
            line-height: 1.7;
        }

        .message-author {
            margin-top: 1.5rem;
            font-family: 'Montserrat', sans-serif;
            font-size: 0.95rem;
            color: #8b6f47;
            font-weight: 600;
        }

        .message-date {
            font-size: 0.8rem;
            color: #999;
            margin-top: 0.5rem;
        }

        .no-messages {
            grid-column: 1 / -1;
            text-align: center;
            color: #999;
            font-style: italic;
        }

        .message-card {
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 0.5s ease, transform 0.5s ease;
        }

        .message-card.visible {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>

<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg">
        <div class="container-fluid">
            <div class="logo-text">A & P</div>
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse justify-content-center" id="navbarNav">
                <ul class="nav-links">
                    <li><a href="#hero">Accueil</a></li>
                    <li><a href="#couple">Notre Histoire</a></li>
                    <li><a href="#location">Lieu</a></li>
                    <li><a href="#contact">Contact</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero" id="hero">
        <div class="carousel-wrapper" id="heroCarousel">
            <?php
            // Fetch hero photos with proper try/catch and output slides afterwards to keep braces balanced
            try {
                $stmt = $pdo->query("SELECT filename FROM carousel_images WHERE section = 'hero' ORDER BY order_position ASC");
                $heroPhotos = $stmt->fetchAll(PDO::FETCH_ASSOC);
            } catch (Exception $e) {
                // On DB error, ensure $heroPhotos is defined so the UI falls back to defaults
                $heroPhotos = [];
            }

            $i = 0;

            if (empty($heroPhotos)) {
                $heroPhotos = [
                    ['filename' => 'https://images.unsplash.com/photo-1519741497674-611481863552?w=1200&h=800&fit=crop'],
                    ['filename' => 'https://images.unsplash.com/photo-1531746020798-e6953c6e8e04?w=1200&h=800&fit=crop'],
                    ['filename' => 'https://images.unsplash.com/photo-1465146072230-91cabc968266?w=1200&h=800&fit=crop']
                ];
            }

            foreach ($heroPhotos as $photo):
            ?>
                <div class="carousel-slide <?= $i === 0 ? 'active' : '' ?>">
                    <img src="<?= !empty($photo['filename']) && !str_starts_with($photo['filename'], 'http')
                                    ? UPLOADS_URL . 'carousel_hero/' . htmlspecialchars($photo['filename'])
                                    : htmlspecialchars($photo['filename']) ?>"
                        alt="Slide <?= $i + 1 ?>">
                </div>
            <?php $i++;
            endforeach; ?>

            <div class="carousel-controls">
                <?php foreach ($heroPhotos as $idx => $photo): ?>
                    <div class="carousel-dot <?= $idx === 0 ? 'active' : '' ?>" data-index="<?= $idx ?>"></div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="hero-content">
            <p class="hero-subtitle">Mariage Coutumier</p>
            <h1 class="hero-title">We're Getting Married</h1>
            <div class="hero-names">Aaron & Princillia</div>
            <p class="hero-quote">
                "L'homme quittera son père et sa mère, s'attachera à sa femme..."
                <br><span style="font-size: 0.9em;">Genèse 2:24</span>
            </p>
            <a class="cta-button" href="https://shorturl.at/zpFri">Confirmez votre présence</a>
        </div>
    </section>

    <!-- Countdown Section -->
    <section class="countdown-section">
        <h2 class="countdown-title">Compte à rebours</h2>
        <div class="countdown">
            <div class="countdown-item">
                <div class="countdown-number" id="days">0</div>
                <div class="countdown-label">Jours</div>
            </div>
            <div class="countdown-item">
                <div class="countdown-number" id="hours">0</div>
                <div class="countdown-label">Heures</div>
            </div>
            <div class="countdown-item">
                <div class="countdown-number" id="minutes">0</div>
                <div class="countdown-label">Minutes</div>
            </div>
            <div class="countdown-item">
                <div class="countdown-number" id="seconds">0</div>
                <div class="countdown-label">Secondes</div>
            </div>
        </div>
    </section>

    <!-- Couple Section -->
    <!-- Couple Section -->
    <section class="couple-section" id="couple">
        <div class="container">
            <h2 class="section-title">Notre Couple</h2>
            <div class="couple-grid">
                <?php
                $groom = null;
                $bride = null;
                try {
                    $stmt = $pdo->query("SELECT filename, description FROM carousel_images WHERE section = 'groom' LIMIT 1");
                    $groom = $stmt->fetch(PDO::FETCH_ASSOC); // retourne false ou tableau

                    $stmt = $pdo->query("SELECT filename, description FROM carousel_images WHERE section = 'bride' LIMIT 1");
                    $bride = $stmt->fetch(PDO::FETCH_ASSOC);
                } catch (Exception $e) {
                    // En cas d'erreur, on laisse null → fallback
                }
                ?>
                <div class="couple-card">
                    <div class="couple-image">
                        <?php if ($groom && !empty($groom['filename'])): ?>
                            <img src="<?= 'uploads/couple/groom/' . htmlspecialchars($groom['filename']) ?>" alt="Aaron">
                        <?php else: ?>
                            <img src="https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=400&h=500&fit=crop" alt="Aaron">
                        <?php endif; ?>
                    </div>
                    <h3 class="couple-name">Aaron</h3>
                    <p class="couple-bio">
                        <?= htmlspecialchars($groom['description'] ?? 'Homme de cœur, de vision et de passion. Aaron apporte joie et stabilité à nos vies. Son amour sincère et sa dévotion font de lui un partenaire extraordinaire.') ?>
                    </p>
                </div>

                <div class="heart-divider">
                    <i class="fas fa-heart"></i>
                </div>

                <div class="couple-card">
                    <div class="couple-image">
                        <?php if ($bride && !empty($bride['filename'])): ?>
                            <img src="<?= 'uploads/couple/bride/' . htmlspecialchars($bride['filename']) ?>" alt="Princillia">
                        <?php else: ?>
                            <img src="https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=400&h=500&fit=crop" alt="Princillia">
                        <?php endif; ?>
                    </div>
                    <h3 class="couple-name">Princillia</h3>
                    <p class="couple-bio">
                        <?= htmlspecialchars($bride['description'] ?? 'Femme de grâce, d\'élégance et de force. Princillia illumine chaque moment de sa présence chaleureuse. Son amour vrai et sa tendresse sont les fondations de notre union.') ?>
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Story Section -->
    <section class="story-section">
        <div class="container">
            <h2 class="section-title">Notre Histoire</h2>
            <p class="story-text">
                Notre histoire a commencé avec un simple regard qui a changé nos vies à jamais.
                Depuis ce jour, chaque moment passé ensemble a renforcé notre amour et notre engagement l'un envers l'autre.
                <br><br>
                Aujourd'hui, nous sommes ravis de partager ce jour spécial avec vous et de célébrer notre union entourés de nos proches.
                Bienvenue dans notre univers, où l'amour est au cœur de tout ce que nous faisons.
            </p>
        </div>
    </section>

    <!-- Messages des Invités -->
    <section class="guest-messages-section" style="padding: 6rem 2rem; background: linear-gradient(135deg, #f5f5f2 0%, #e8e6e1 100%);">
        <div class="container">
            <h2 class="section-title">💌 Messages de nos Proches</h2>
            <div class="messages-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 2rem; margin-top: 3rem;">
                <?php
                try {
                    $stmt = $pdo->prepare("
    SELECT nom AS name, message_maries, date_created 
    FROM invites 
    WHERE status = 'A confirmé' 
      AND approved = 1                     -- ⬅️ SEULEMENT les approuvés
      AND message_maries IS NOT NULL 
      AND TRIM(message_maries) != ''
    ORDER BY date_created DESC 
    LIMIT 20
");
                    $stmt->execute();
                    $guestMessages = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    if ($guestMessages):
                        foreach ($guestMessages as $msg):
                ?>
                            <div class="message-card" style="
                    background: white;
                    padding: 1.5rem;
                    border-radius: 15px;
                    box-shadow: 0 5px 15px rgba(0,0,0,0.05);
                    position: relative;
                    font-family: 'Lora', serif;
                ">
                                <div style="
                        position: absolute;
                        top: -20px;
                        left: 20px;
                        width: 40px;
                        height: 40px;
                        background: #d4a574;
                        border-radius: 50%;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        color: white;
                        font-weight: bold;
                    ">❝</div>
                                <p style="margin-top: 20px; color: #2c2c2c; line-height: 1.7;">
                                    <?= nl2br(htmlspecialchars($msg['message_maries'])) ?>
                                </p>
                                <div class="message-author">— <?= htmlspecialchars($msg['name']) ?></div>
                                <div class="message-date"><?= date('j M Y', strtotime($msg['date_created'])) ?></div>
                            </div>
                        <?php
                        endforeach;
                    else:
                        ?>
                        <div class="no-messages" style="grid-column: 1 / -1; text-align: center; color: #999;">
                            Soyez le premier à nous laisser un mot d’amour 💬
                        </div>
                    <?php
                    endif;
                } catch (Exception $e) {
                    // En cas d'erreur de la BDD on affiche un message de secours
                    ?>
                    <div class="no-messages" style="grid-column: 1 / -1; text-align: center; color: #999;">
                        <!-- Aucun message disponible pour le moment. -->
                        Soyez le premier à nous laisser un mot d’amour 💬
                    </div>
                <?php
                }
                ?>
            </div>
        </div>
    </section>

    <!-- Pagne Carousel Section -->
    <!-- Pagne Carousel Section -->
    <section class="pagne-carousel-section">
        <div class="container">
            <h2 class="section-title">Le Pagne Traditionnel</h2>
            <div class="pagne-carousel-wrapper">
                <?php
                // Initialisation sécurisée
                $pagnePhotos = [];

                try {
                    $stmt = $pdo->query("SELECT filename, title, description FROM carousel_images WHERE section = 'pagne' ORDER BY order_position ASC");
                    $pagnePhotos = $stmt->fetchAll(PDO::FETCH_ASSOC);

                    // Fallback si aucune photo
                    if (empty($pagnePhotos)) {
                        $pagnePhotos = [
                            [
                                'filename' => 'https://images.unsplash.com/photo-1582572652897-7e1affba1238?w=600&h=400&fit=crop',
                                'title' => 'Pagne Traditionnel',
                                'description' => 'Découvrez notre collection de pagnes traditionnels'
                            ]
                        ];
                    }
                } catch (Exception $e) {
                    // Fallback en cas d'erreur BDD
                    $pagnePhotos = [
                        [
                            'filename' => 'https://images.unsplash.com/photo-1582572652897-7e1affba1238?w=600&h=400&fit=crop',
                            'title' => 'Pagne Traditionnel',
                            'description' => 'Découvrez notre collection de pagnes traditionnels'
                        ]
                    ];
                }

                // ✅ Affichage UNIFIÉ : on utilise TOUJOURS $pagnePhotos
                foreach ($pagnePhotos as $idx => $photo):
                    $isExternal = strpos($photo['filename'], 'http') === 0;
                    $imgSrc = $isExternal
                        ? $photo['filename']
                        : UPLOADS_URL . 'carousel_pagne/' . htmlspecialchars($photo['filename']);
                ?>
                    <div class="pagne-slide <?= $idx === 0 ? 'active' : '' ?>">
                        <img src="<?= $imgSrc ?>" alt="<?= htmlspecialchars($photo['title']) ?>">
                        <div class="pagne-overlay">
                            <div class="pagne-slide-title"><?= htmlspecialchars($photo['title'] ?: 'Pagne Traditionnel') ?></div>
                            <div class="pagne-slide-description"><?= htmlspecialchars($photo['description'] ?: '') ?></div>
                        </div>
                    </div>
                <?php endforeach; ?>

                <button class="carousel-arrow pagne-prev" onclick="prevPagne()">❮</button>
                <button class="carousel-arrow pagne-next" onclick="nextPagne()">❯</button>

                <div class="pagne-dots">
                    <?php foreach ($pagnePhotos as $i => $photo): ?>
                        <div class="pagne-dot <?= $i === 0 ? 'active' : '' ?>" data-index="<?= $i ?>" onclick="goToPagne(<?= $i ?>)"></div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="pagne-info">
                <p>Le pagne traditionnel est bien plus qu'un simple vêtement. Il représente l'essence de notre culture, notre fierté et notre respect envers nos traditions ancestrales.</p>
                <p>Pour cette célébration coutumière, nous vous invitons à porter les couleurs et motifs traditionnels qui témoignent de notre patrimoine commun. C'est une occasion magnifique de célébrer ensemble nos racines.</p>
                <p><strong><!-- Le tissu spécifique du mariage sera fourni lors de votre confirmation de présence. -->Si vous en avez besoin contactez-nous</strong></p>
            </div>
        </div>
    </section>

    <!-- Dress Code Section -->
    <section class="dress-code-section">
        <div class="container">
            <h2 class="section-title">Conseils d'Habillement</h2>
            <div class="row justify-content-center g-4">
                <!-- Pour les Hommes -->
                <div class="col-12 col-md-6">
                    <div class="dress-code-card">
                        <div class="dress-code-icon">
                            <i class="fas fa-user"></i>
                        </div>
                        <h4>Pour les Hommes</h4>
                        <ul>
                            <li>Pagne traditionnel avec chemise blanche</li>
                            <li>Chaussures de cérémonie</li>
                            <li>Accessoires traditionnels</li>
                            <li>Coiffure soignée</li>
                            <li>Bijoux discrets et élégants</li>
                        </ul>
                    </div>
                </div>

                <!-- Pour les Femmes -->
                <div class="col-12 col-md-6">
                    <div class="dress-code-card">
                        <div class="dress-code-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h4>Pour les Femmes</h4>
                        <ul>
                            <li>Pagne traditionnel coordonné</li>
                            <li>Chemise ou top élégant</li>
                            <li>Coiffure traditionnelle arrangée</li>
                            <li>Bijoux traditionnels</li>
                            <li>Maquillage naturel et soigné</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

<!-- Location Section -->
<?php
$locationData = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT * FROM wedding_location WHERE id = 1");
        $locationData = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        // Garder les valeurs par défaut en cas d’erreur
    }
}

$address = $locationData['address'] ?? 'À confirmer';
$schedule = $locationData['schedule'] ?? 'À confirmer';
$contact = $locationData['contact'] ?? 'À confirmer';
$map_iframe = $locationData['map_iframe'] ?? '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3970.0348919346286!2d-5.546910!3d6.824192!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zNi4zODcwLTUuNTQ2N0U!5e0!3m2!1sfr!2sci!4v" width="600" height="450" style="border:0;" allowfullscreen loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>';
$lat = $locationData['latitude'] ?? '6.824192';
$lng = $locationData['longitude'] ?? '-5.546910';
?>
<section class="location-section" id="location">
    <div class="container">
        <h2 class="section-title">Lieu de la Cérémonie</h2>
        <div class="location-grid">
            <div class="location-info" id="contact">
                <h3>Lieu de Célébration</h3>
                <div class="location-details">
                    <p><span class="location-label">📍 Adresse :</span><br><?= htmlspecialchars($address) ?></p>
                </div>
                <div class="location-details">
                    <p><span class="location-label">🕐 Horaire :</span><br><?= htmlspecialchars($schedule) ?></p>
                </div>
                <div class="location-details">
                    <p><span class="location-label">📞 Contact :</span><br><?= htmlspecialchars($contact) ?></p>
                </div>
                <!-- ✅ BOUTON D’ITINÉRAIRE GUIDÉ (fonctionne sur mobile & desktop) -->
                <a href="https://www.google.com/maps/dir/?api=1&destination=<?= $lat ?>,<?= $lng ?>" 
                   target="_blank" 
                   class="cta-button">
                    Itinéraire vers le lieu
                </a>
            </div>
            <div class="map-container">
                <?= $map_iframe ?>
            </div>
        </div>
    </div>
</section>

    <!-- Events Teaser -->
    <section class="events-teaser">
        <h2 class="events-teaser-title">Nos Événements de Mariage</h2>
        <div class="events-grid">
            <div class="event-card">
                <h4>Mariage Coutumier</h4>
                <div class="event-date">20 Décembre 2025</div>
                <span class="event-status">Confirmé</span>
            </div>
            <div class="event-card">
                <h4>Mariage Civil & Religieux</h4>
                <div class="event-date">Date En cours de définition</div>
                <span class="event-status coming">À venir</span>
            </div>
        </div>
    </section>

    <!-- Precious Moments Section -->
    <section class="moments-section">
        <div class="container">
            <h2 class="section-title">Nos Moments Précieux</h2>
            <div class="moments-carousel">
                <?php
                try {
                    $stmt = $pdo->query("SELECT filename, title, description FROM carousel_images WHERE section = 'moments' ORDER BY order_position ASC");
                    $momentPhotos = $stmt->fetchAll(PDO::FETCH_ASSOC);
                    $momentDir = 'uploads/carousel_moments/';

                    if (empty($momentPhotos)) {
                        // Fallback
                        $momentPhotos = [
                            ['filename' => 'https://images.unsplash.com/photo-1519741497674-611481863552?w=1000&h=600&fit=crop', 'title' => 'Notre Première Rencontre', 'description' => 'Un instant magique qui a tout changé'],
                            ['filename' => 'https://images.unsplash.com/photo-1515886657613-9f3515b0c78f?w=1000&h=600&fit=crop', 'title' => 'Nos Aventures Ensemble', 'description' => 'Chaque jour est une nouvelle aventure remplie d\'amour'],
                            ['filename' => 'https://images.unsplash.com/photo-1519046904884-53103b34b206?w=1000&h=600&fit=crop', 'title' => 'Nos Rêves Réalisés', 'description' => 'Aujourd\'hui, nous célébrons l\'union de deux âmes'],
                            ['filename' => 'https://images.unsplash.com/photo-1506794778202-cad84cf45f1d?w=1000&h=600&fit=crop', 'title' => 'L\'Engagement', 'description' => 'Une promesse d\'amour éternel']
                        ];
                    }

                    $idx = 0;
                    foreach ($momentPhotos as $photo):
                ?>
                        <div class="moment-slide <?= $idx === 0 ? 'active' : '' ?>">
                            <img src="<?= strpos($photo['filename'], 'http') === 0 ? $photo['filename'] : htmlspecialchars($momentDir . $photo['filename']) ?>" alt="Moment <?= $idx + 1 ?>">
                            <div class="moment-slide-overlay">
                                <div class="moment-title"><?= htmlspecialchars($photo['title'] ?: 'Moment') ?></div>
                                <div class="moment-description"><?= htmlspecialchars($photo['description'] ?: '') ?></div>
                            </div>
                        </div>
                    <?php $idx++;
                    endforeach; ?>
                <?php } catch (Exception $e) { ?>
                    <div class="moment-slide active">
                        <img src="https://images.unsplash.com/photo-1519741497674-611481863552?w=1000&h=600&fit=crop" alt="Moment 1">
                        <div class="moment-slide-overlay">
                            <div class="moment-title">Notre Première Rencontre</div>
                            <div class="moment-description">Un instant magique qui a tout changé</div>
                        </div>
                    </div>
                <?php } ?>

                <button class="carousel-arrow prev" onclick="prevMoment()">❮</button>
                <button class="carousel-arrow next" onclick="nextMoment()">❯</button>

                <div class="moment-dots">
                    <?php foreach ($momentPhotos as $i => $photo): ?>
                        <div class="moment-dot <?= $i === 0 ? 'active' : '' ?>" data-index="<?= $i ?>" onclick="goToMoment(<?= $i ?>)"></div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container">
            <p>© 2025 Aaron & Princillia. Tous droits réservés. | Site créé avec ❤️ by <a href="https://www.instagram.com/v_k_i_z?igsh=NGg4aXp4c3JyNDV0&utm_source=qr" target="_blank" rel="noopener noreferrer"> V_K_i_Z</a> </p>
            <p>Design élégant et traditionnel pour célébrer votre union.</p>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Countdown Timer
        const countDownDate = new Date("December 20, 2025 00:00:00").getTime();

        const x = setInterval(function() {
            const now = new Date().getTime();
            const distance = countDownDate - now;

            const days = Math.floor(distance / (1000 * 60 * 60 * 24));
            const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((distance % (1000 * 60)) / 1000);

            document.getElementById("days").innerHTML = days;
            document.getElementById("hours").innerHTML = hours;
            document.getElementById("minutes").innerHTML = minutes;
            document.getElementById("seconds").innerHTML = seconds;

            if (distance < 0) {
                clearInterval(x);
                document.getElementById("days").innerHTML = "0";
                document.getElementById("hours").innerHTML = "0";
                document.getElementById("minutes").innerHTML = "0";
                document.getElementById("seconds").innerHTML = "0";
            }
        }, 1000);

        // Hero Carousel
        let currentSlide = 0;
        const slides = document.querySelectorAll('.carousel-slide');
        const dots = document.querySelectorAll('.carousel-dot');

        function showSlide(index) {
            slides.forEach(slide => slide.classList.remove('active'));
            dots.forEach(dot => dot.classList.remove('active'));
            slides[index].classList.add('active');
            dots[index].classList.add('active');
        }

        function nextSlide() {
            currentSlide = (currentSlide + 1) % slides.length;
            showSlide(currentSlide);
        }

        function prevSlide() {
            currentSlide = (currentSlide - 1 + slides.length) % slides.length;
            showSlide(currentSlide);
        }

        dots.forEach((dot, index) => {
            dot.addEventListener('click', () => {
                currentSlide = index;
                showSlide(currentSlide);
            });
        });

        setInterval(nextSlide, 5000);

        // Moments Carousel
        let currentMoment = 0;
        const moments = document.querySelectorAll('.moment-slide');
        const momentDots = document.querySelectorAll('.moment-dot');

        function showMoment(index) {
            moments.forEach(m => m.classList.remove('active'));
            momentDots.forEach(dot => dot.classList.remove('active'));
            moments[index].classList.add('active');
            momentDots[index].classList.add('active');
        }

        function nextMoment() {
            currentMoment = (currentMoment + 1) % moments.length;
            showMoment(currentMoment);
        }

        function prevMoment() {
            currentMoment = (currentMoment - 1 + moments.length) % moments.length;
            showMoment(currentMoment);
        }

        function goToMoment(index) {
            currentMoment = index;
            showMoment(index);
        }

        momentDots.forEach((dot, index) => {
            dot.addEventListener('click', () => goToMoment(index));
        });
    </script>

    <script>
        console.log("Script pagne chargé");

        let pagneIndex = 0;
        const pagneSlides = document.querySelectorAll('.pagne-slide');
        const pagneDots = document.querySelectorAll('.pagne-dot');

        console.log("Slides trouvées:", pagneSlides.length);
        console.log("Dots trouvées:", pagneDots.length);

        // ... reste du code ...


        function showPagneSlide(n) {
            pagneSlides.forEach(slide => slide.classList.remove('active'));
            pagneDots.forEach(dot => dot.classList.remove('active'));

            if (pagneSlides.length > 0) {
                pagneSlides[n].classList.add('active');
                if (pagneDots[n]) pagneDots[n].classList.add('active');
            }
        }

        function nextPagne() {
            pagneIndex = (pagneIndex + 1) % pagneSlides.length;
            showPagneSlide(pagneIndex);
        }

        function prevPagne() {
            pagneIndex = (pagneIndex - 1 + pagneSlides.length) % pagneSlides.length;
            showPagneSlide(pagneIndex);
        }

        function goToPagne(n) {
            pagneIndex = n;
            showPagneSlide(pagneIndex);
        }

        // Auto-rotate carousel tous les 8 secondes
        setInterval(() => {
            nextPagne();
        }, 8000);

        // Animer les cartes à l'apparition
        document.addEventListener('DOMContentLoaded', () => {
            const cards = document.querySelectorAll('.message-card');
            cards.forEach((card, i) => {
                setTimeout(() => card.classList.add('visible'), i * 150);
            });
        });
    </script>

</body>

</html>