<?php
// ---------------------------
// 1. Charger la librairie PHP QR Code
// ---------------------------
require_once __DIR__ . '/lib/qrlib.php';

// ---------------------------
// 2. Vérifier que l'ID est fourni dans l'URL
// ---------------------------
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('ID invalide.');
}

$guest_id = (int) $_GET['id'];

// ---------------------------
// 3. Connexion à la base de données
// ---------------------------
try {
    $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (Exception $e) {
    die("Erreur DB : " . $e->getMessage());
}

// ---------------------------
// 4. Récupérer les infos de l'invité
// ---------------------------
$stmt = $pdo->prepare("SELECT nom, telephone FROM invites WHERE id = ?");
$stmt->execute([$guest_id]);
$invite = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$invite) {
    die('Invité introuvable.');
}

// ---------------------------
// 5. Construire la donnée à encoder dans le QR code
// ---------------------------
// Exemple : un lien vers la page d'invitation
$data = "https://vkiz-digital.website/aaronandprincillia/verify_invite.php?id=" . $guest_id;

// ---------------------------
// 6. Générer le QR code en image PNG
// ---------------------------
// On définit un dossier pour stocker les QR codes
$qr_dir = __DIR__ . '/qr_codes/';
if (!file_exists($qr_dir)) {
    mkdir($qr_dir, 0777, true);
}

$filename = $qr_dir . 'qr_invite_' . $guest_id . '.png';

// QR_ECLEVEL_L : niveau de correction (L = Low)
// Taille : 4 (pixels par module)
QRcode::png($data, $filename, QR_ECLEVEL_L, 4, 0, array(205, 133, 63), array(255, 255, 255));

// ---------------------------
// 7. Afficher le QR code directement dans le navigateur
// ---------------------------
header('Content-Type: image/png');
readfile($filename);
