<?php
require_once('lib/tcpdf/tcpdf.php');

function generateInvitationPDF($inviteId, $pdo)
{
  // Récupérer les infos de l'invité
  $stmt = $pdo->prepare("SELECT * FROM invites WHERE id = ?");
  $stmt->execute([$inviteId]);
  $invite = $stmt->fetch(PDO::FETCH_ASSOC);

  if (!$invite) {
    throw new Exception("Invitation introuvable");
  }

  $isCouple = (strtolower($invite['type_invitation']) === 'couple');

  // Créer le PDF en format A5 (148 x 210 mm)
  $pdf = new TCPDF('P', 'mm', 'A5', true, 'UTF-8', false);

  // Supprimer header et footer par défaut
  $pdf->setPrintHeader(false);
  $pdf->setPrintFooter(false);

  // Informations du document
  $pdf->SetCreator('Aaron & Princillia Wedding');
  $pdf->SetAuthor('Aaron & Princillia');
  $pdf->SetTitle('Invitation Mariage Coutumier');

  // Marges
  $pdf->SetMargins(0, 0, 0);
  $pdf->SetAutoPageBreak(false, 0);

  // Ajouter une page
  $pdf->AddPage();

  // === IMAGE DE FOND ===
  $bgImage = 'images/invitation_background.jpg'; // Ton image compressée
  if (file_exists($bgImage)) {
    $pdf->Image($bgImage, 0, 0, 148, 210, '', '', '', false, 300, '', false, false, 0);
  }

  // === NOM INVITÉ - Au milieu supérieur ===
  $pdf->SetFont('helvetica', 'BI', 28);
  $pdf->SetTextColor(212, 175, 55); // Doré

  $yGuest = 56; // Nom un peu plus haut

  if ($isCouple) {
    $pdf->SetY($yGuest);
    $pdf->Cell(0, 8, htmlspecialchars($invite['titre1']) . ' & ' . htmlspecialchars($invite['titre2']), 0, 1, 'C');
    $pdf->SetFont('helvetica', 'B', 24);
    $pdf->Cell(0, 10, htmlspecialchars($invite['nom']) . ' & ' . htmlspecialchars($invite['nom2']), 0, 1, 'C');
  } else {
    $pdf->SetY($yGuest);
    $pdf->Cell(0, 8, htmlspecialchars($invite['titre1']), 0, 1, 'C');
    $pdf->SetFont('helvetica', 'B', 24);
    $pdf->Cell(0, 10, htmlspecialchars($invite['nom']), 0, 1, 'C');
  }

  // === QR CODE - Au centre ===
  $qrCodePath = $invite['qr_code'];
  if ($qrCodePath && file_exists($qrCodePath)) {
    // Position du QR code au milieu
    $qrY = 82;
    $qrX = 54; // Centré horizontalement (148/2 - 20 = 54)
    $qrSize = 40; // Taille du QR code

    $pdf->Image($qrCodePath, $qrX, $qrY, $qrSize, $qrSize, '', '', '', false, 300, '', false, false, 0);
  }

  // Sauvegarder le PDF
  $pdfDir = 'invitations_pdf';
  if (!file_exists($pdfDir)) {
    mkdir($pdfDir, 0777, true);
  }

  $pdfFileName = $pdfDir . '/invitation_' . $inviteId . '.pdf';
  $pdf->Output(__DIR__ . '/' . $pdfFileName, 'F');

  // Mettre à jour la BDD avec le chemin du PDF
  $updatePdf = $pdo->prepare("UPDATE invites SET pdf_file = ? WHERE id = ?");
  $updatePdf->execute([$pdfFileName, $inviteId]);

  return $pdfFileName;
}
