<?php
session_start();
include 'config.php';

function login($username, $password)
{
    $conn = $GLOBALS['conn'];
    $sql = "SELECT * FROM administrateur WHERE username=? AND password=?";
    $stmt = $conn->prepare($sql);
    $stmt->execute(array($username, $password));
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        $_SESSION['admin_id'] = $user['id_admin'];
        $_SESSION['admin_username'] = $user['username'];
        return true;
    } else {
        return false;
    }
}

/* fonction pour la verification d un utilisateur */
function login1($adresse_mail, $password)
{
    $conn = $GLOBALS['conn'];
    $req_select_user = " SELECT * FROM administrateur
                        WHERE username = ? /*? represente linformation qui vient de cchaque variable selon l'ordre */
                        AND password = ? ;";
    $sql = $conn->prepare($req_select_user);
    $sql->execute(array($adresse_mail, $password));

    $nombre_ligne = $sql->rowCount();
    if ($nombre_ligne > 0) {
        $_SESSION['username'] = $adresse_mail;
        return true;
    } else {
        return false;
    }
}


function add_admin($username, $email, $password, $tel, $couverture)
{
    $conn = $GLOBALS['conn'];
    $insert_admin = "INSERT INTO administrateur (username,email,password,tel,photo)
                            VALUES (?,?,?,?,?);";
    $sql = $conn->prepare($insert_admin);
    $sql->execute(array($username, $email, $password, $tel, $couverture));

    $nombre_ligne = $sql->rowCount();
    if ($nombre_ligne > 0) {
        return true;
    } else {
        return false;
    }
}

function toRomanNumeral($num) {
    // Vérifier que le nombre est entre 1 et 30
    if ($num < 1 || $num > 30) {
        return $num; // Retourne le nombre original si hors limites
    }

    $romanNumeralMap = array(
        30 => 'XXX',
        29 => 'XXIX',
        28 => 'XXVIII',
        27 => 'XXVII',
        26 => 'XXVI',
        25 => 'XXV',
        24 => 'XXIV',
        23 => 'XXIII',
        22 => 'XXII',
        21 => 'XXI',
        20 => 'XX',
        19 => 'XIX',
        18 => 'XVIII',
        17 => 'XVII',
        16 => 'XVI',
        15 => 'XV',
        14 => 'XIV',
        13 => 'XIII',
        12 => 'XII',
        11 => 'XI',
        10 => 'X',
        9 => 'IX',
        8 => 'VIII',
        7 => 'VII',
        6 => 'VI',
        5 => 'V',
        4 => 'IV',
        3 => 'III',
        2 => 'II',
        1 => 'I'
    );

    return $romanNumeralMap[$num];
}
/**
 * Redimensionne et compresse une image
 * @param string $source Chemin de l'image source (ex: $_FILES['photo']['tmp_name'])
 * @param string $destination Chemin de sortie (ex: 'uploads/carousel_hero/image.jpg')
 * @param int $maxWidth Largeur max (ex: 1200)
 * @param int $maxHeight Hauteur max (ex: 800)
 * @param int $quality Qualité JPEG (1-100, 80 est un bon compromis)
 */
function resizeAndCompressImage($source, $destination, $maxWidth = 1200, $maxHeight = 800, $quality = 80) {
    // Détecter le type d'image
    $info = getimagesize($source);
    if (!$info) return false;

    $mime = $info['mime'];
    switch ($mime) {
        case 'image/jpeg':
            $image = imagecreatefromjpeg($source);
            break;
        case 'image/png':
            $image = imagecreatefrompng($source);
            break;
        case 'image/webp':
            $image = imagecreatefromwebp($source);
            break;
        default:
            return false; // Format non supporté
    }

    if (!$image) return false;

    // Obtenir les dimensions originales
    $originalWidth = imagesx($image);
    $originalHeight = imagesy($image);

    // Calculer le ratio de redimensionnement
    $ratio = min($maxWidth / $originalWidth, $maxHeight / $originalHeight, 1);
    $newWidth = (int)($originalWidth * $ratio);
    $newHeight = (int)($originalHeight * $ratio);

    // Créer une nouvelle image redimensionnée
    $resized = imagecreatetruecolor($newWidth, $newHeight);

    // Pour PNG/WebP : conserver la transparence
    if ($mime === 'image/png') {
        imagealphablending($resized, false);
        imagesavealpha($resized, true);
        $transparent = imagecolorallocatealpha($resized, 255, 255, 255, 127);
        imagefilledrectangle($resized, 0, 0, $newWidth, $newHeight, $transparent);
    }

    imagecopyresampled($resized, $image, 0, 0, 0, 0, $newWidth, $newHeight, $originalWidth, $originalHeight);

    // Sauvegarder avec compression
    switch ($mime) {
        case 'image/jpeg':
            imagejpeg($resized, $destination, $quality);
            break;
        case 'image/png':
            imagepng($resized, $destination, 6); // 0-9, 6 = bon équilibre
            break;
        case 'image/webp':
            imagewebp($resized, $destination, $quality);
            break;
    }

    // Libérer la mémoire
    imagedestroy($image);
    imagedestroy($resized);
    return true;
}
?>