<?php
try {
    $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (Exception $e) {
    die("Erreur DB : " . $e->getMessage());
}

$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    die("ID invalide.");
}

// Récupérer les infos invité
$stmt = $pdo->prepare("SELECT * FROM invites WHERE id = ?");
$stmt->execute([$id]);
$invite = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$invite) {
    die("Invitation non trouvée.");
}

?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <title>Invitation de <?= htmlspecialchars($invite['nom']) ?></title>
  <link rel="apple-touch-icon" sizes="180x180" href="favicon_io/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="favicon_io/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="favicon_io/favicon-16x16.png">
<link rel="manifest" href="favicon_io/site.webmanifest">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body class="p-4">
  <div class="container" style="max-width: 480px;">
    <h1 class="mb-4" style="text-shadow: 0 1px 3px rgba(0,0,0,0.2);">Votre invitation</h1>

    <p><strong>Nom complet :</strong> <?= htmlspecialchars($invite['nom']) ?></p>
    <p><strong>Table assignée :</strong> <?= htmlspecialchars($invite['table_num'] ?? 'À définir à l\'entrée') ?></p>
    <p><strong>Code Invitation :</strong> <?= htmlspecialchars($invite['code_invitation']) ?></p>
    <p><strong>Status :</strong> Invité</p>

    <?php if (!empty($invite['qr_code']) && file_exists($invite['qr_code'])): ?>
      <div class="text-center mb-4">
        <img src="<?= htmlspecialchars($invite['qr_code']) ?>" alt="QR Code Invitation" />
      </div>
    <?php endif; ?>


  </div>
</body>
</html>
