<?php
session_start();
$message = '';
$errors = [];
$qrCodePath = '';
$step = 'code'; // 'code' ou 'form' ou 'success'
$invite = null;

try {
  $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  ]);
} catch (Exception $e) {
  die("Erreur DB : " . $e->getMessage());
}

// Étape 1 : Vérifier le code d'invitation
if (isset($_POST['verify_code'])) {
  $codeInvit = trim($_POST['code_invitation'] ?? '');

  if ($codeInvit === '') {
    $errors[] = "Veuillez entrer votre code d'invitation.";
  } else {
    // Vérifier si le code existe
    $stmt = $pdo->prepare("SELECT * FROM invites WHERE code_invitation = ?");
    $stmt->execute([$codeInvit]);
    $invite = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($invite) {
      // Vérifier le statut
      if ($invite['status'] === 'Présent dans la salle') {
        $step = 'already_confirmed';
      } elseif ($invite['status'] === 'A confirmé') {
        $step = 'already_confirmed';
      } else {
        $step = 'form';
      }
      $_SESSION['temp_invite_id'] = $invite['id'];
      $_SESSION['temp_invite_data'] = $invite; // Sauvegarder toutes les données
    } else {
      $errors[] = "Code d'invitation invalide.";
    }
  }
}

// Étape 2 : Traiter le formulaire de confirmation
if (isset($_POST['confirm_invitation'])) {
  $inviteId = $_SESSION['temp_invite_id'] ?? null;

  if (!$inviteId) {
    $errors[] = "Session expirée. Veuillez recommencer.";
  } else {
    // Récupérer l'invitation
    $stmt = $pdo->prepare("SELECT * FROM invites WHERE id = ?");
    $stmt->execute([$inviteId]);
    $invite = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$invite) {
      $errors[] = "Invitation introuvable.";
    } else {
      // Détecter si c'est un couple (insensible à la casse)
      $isCouple = (strtolower($invite['type_invitation']) === 'couple');

      // Récupérer les données du formulaire
      $nom = trim($_POST['nom'] ?? '');
      $nom2 = $isCouple ? trim($_POST['nom2'] ?? '') : '';
      $telephone = trim($_POST['telephone'] ?? '');
      $message_maries = trim($_POST['message_maries'] ?? '');

      // Validation
      if (empty($nom)) {
        $errors[] = "Le nom est obligatoire.";
      }

      if ($isCouple && empty($nom2)) {
        $errors[] = "Le nom de Madame est obligatoire pour un couple.";
      }

      if (empty($telephone)) {
        $errors[] = "Le numéro WhatsApp est obligatoire.";
      } else {
        // Nettoyer et convertir le numéro
        $country_code = trim($_POST['country_code'] ?? '243');
        $telephone = trim($_POST['telephone'] ?? '');
        $telephone = str_replace(['+', ' ', '-', '(', ')'], '', $telephone);

        // Ajouter le code pays
        $telephone = $country_code . $telephone;

        if (strlen($telephone) === 9) {
          // Format: 812345678 → Ajouter 243
          $telephone = '243' . $telephone;
        } elseif (strlen($telephone) === 10 && $telephone[0] === '0') {
          // Format: 0812345678 → Remplacer 0 par 243
          $telephone = '243' . substr($telephone, 1);
        } elseif (strlen($telephone) === 12 && substr($telephone, 0, 3) === '243') {
          // Format: 243812345678 → OK
          $telephone = $telephone;
        } else {
          $errors[] = "Format de numéro invalide. Utilisez: 0812345678 ou 243812345678";
        }

        // Vérifier que ce sont des chiffres
        if (!ctype_digit($telephone)) {
          $errors[] = "Le numéro ne doit contenir que des chiffres.";
        }
      }

      // Si pas d'erreurs, mettre à jour et générer QR code
      if (empty($errors)) {
        // Mettre à jour la base de données
        $nombre_personnes = $isCouple ? 2 : 1;

        if ($isCouple) {
          $update = $pdo->prepare("UPDATE invites SET nom = ?, nom2 = ?, telephone = ?, status = 'A confirmé', nombre_personnes_presentes = ?, message_maries = ?, approved = 0 WHERE id = ?");
          $update->execute([$nom, $nom2, $telephone, $nombre_personnes, $message_maries, $invite['id']]);
        } else {
          $update = $pdo->prepare("UPDATE invites SET nom = ?, telephone = ?, status = 'A confirmé', nombre_personnes_presentes = ?, message_maries = ?, approved = 0 WHERE id = ?");
          $update->execute([$nom, $telephone, $nombre_personnes, $message_maries, $invite['id']]);
        }

        // Générer QR code
        require_once 'lib/qrlib.php';

        $qrData = "https://vkiz-digital.website/aaronandprincillia/verify_invite.php?id=" . $invite['id'];
        $qrFile = 'qrcodes/invitation_' . $invite['id'] . '.png';

        if (!file_exists('qrcodes')) {
          mkdir('qrcodes', 0777, true);
        }

        QRcode::png($qrData, $qrFile, QR_ECLEVEL_L, 4);

        // Enregistrer chemin QR code en base
        $updateQr = $pdo->prepare("UPDATE invites SET qr_code = ? WHERE id = ?");
        $updateQr->execute([$qrFile, $invite['id']]);

        // Générer le PDF
        require_once 'generate_pdf.php';
        $pdfFile = generateInvitationPDF($invite['id'], $pdo);

        // Mettre à jour l'invitation avec les nouvelles données
        $invite['nom'] = $nom;
        $invite['nom2'] = $nom2;
        $invite['telephone'] = $telephone;
        $invite['qr_code'] = $qrFile;
        $invite['pdf_file'] = $pdfFile;
        $invite['status'] = 'A confirmé';

        $message = "Confirmation réussie ! Bienvenue " . ($isCouple ? "M. & Mme " . htmlspecialchars($nom) : htmlspecialchars($invite['titre1']) . " " . htmlspecialchars($nom));
        $qrCodePath = $qrFile;
        $step = 'success';

        // Nettoyer la session
        unset($_SESSION['temp_invite_id']);
        unset($_SESSION['temp_invite_data']);
      } else {
        // En cas d'erreur, recharger les données de l'invitation
        $step = 'form';
        $_SESSION['temp_invite_data'] = $invite;
      }
    }
  }
}

// Si on charge la page avec un code en GET (pour revenir)
if (isset($_GET['code']) && empty($_POST)) {
  $codeInvit = trim($_GET['code']);
  $stmt = $pdo->prepare("SELECT * FROM invites WHERE code_invitation = ?");
  $stmt->execute([$codeInvit]);
  $invite = $stmt->fetch(PDO::FETCH_ASSOC);

  if ($invite && ($invite['status'] === 'A confirmé' || $invite['status'] === 'Présent dans la salle')) {
    $step = 'already_confirmed';
    $qrCodePath = $invite['qr_code'];
  }
}

// Récupérer les données de l'invitation si en mode formulaire
if ($step === 'form' && !$invite && isset($_SESSION['temp_invite_data'])) {
  $invite = $_SESSION['temp_invite_data'];
}
?>

<!DOCTYPE html>
<html lang="fr">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Confirmer Invitation - Mariage Aaron & Princillia</title>
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700;900&family=Lora:wght@400;500;600&family=Montserrat:wght@300;400;500;600&family=Great+Vibes:wght@400&display=swap" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" />
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Lora', serif;
      color: #2c2c2c;
      background: #fafaf8;
      overflow-x: hidden;
    }

    /* Header */
    .header {
      background: linear-gradient(135deg, #2c2c2c 0%, #1a1a1a 100%);
      color: white;
      padding: 2rem;
      text-align: center;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
    }

    .header-title {
      font-family: 'Playfair Display', serif;
      font-size: 2rem;
      margin-bottom: 0.5rem;
    }

    .header-subtitle {
      color: #d4a574;
      font-size: 0.95rem;
    }

    /* Container */
    .container {
      max-width: 600px;
      margin: 0 auto;
      padding: 2rem;
    }

    /* Card */
    .card {
      background: white;
      border-radius: 15px;
      padding: 2rem;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
      margin-bottom: 2rem;
    }

    .card-title {
      font-family: 'Playfair Display', serif;
      color: #d4a574;
      font-size: 1.8rem;
      margin-bottom: 1.5rem;
      text-align: center;
    }

    /* Alert */
    .alert {
      background: rgba(40, 167, 69, 0.1);
      color: #28a745;
      padding: 1rem;
      border-radius: 10px;
      margin-bottom: 1.5rem;
      border-left: 4px solid #28a745;
      font-weight: 500;
    }

    .alert-danger {
      background: rgba(220, 53, 69, 0.1);
      color: #dc3545;
      border-left: 4px solid #dc3545;
    }

    .alert-info {
      background: rgba(23, 162, 184, 0.1);
      color: #17a2b8;
      border-left: 4px solid #17a2b8;
    }

    /* Buttons */
    .btn {
      padding: 1rem 2rem;
      border-radius: 50px;
      font-weight: 600;
      cursor: pointer;
      border: none;
      font-family: 'Montserrat', sans-serif;
      transition: all 0.3s ease;
      display: inline-block;
      text-align: center;
    }

    .btn-primary {
      background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
      color: white;
      width: 100%;
      font-size: 1.1rem;
    }

    .btn-success {
      background: linear-gradient(135deg, #28a745 0%, #218838 100%);
      color: white;
      width: 100%;
      font-size: 1.1rem;
    }

    .btn-outline-primary {
      background: transparent;
      color: #007bff;
      border: 2px solid #007bff;
      width: 100%;
      font-size: 1.1rem;
    }

    .btn-success-whatsapp {
      background: #25D366;
      color: white;
      width: 100%;
      font-size: 1.1rem;
    }

    .btn:hover {
      transform: translateY(-3px);
      box-shadow: 0 10px 25px rgba(212, 165, 116, 0.4);
    }

    /* Form */
    .form-label {
      font-weight: 600;
      color: #d4a574;
      margin-bottom: 0.5rem;
    }

    .form-control {
      width: 100%;
      padding: 0.75rem;
      border: 2px solid #eee;
      border-radius: 8px;
      font-size: 1rem;
      font-family: 'Montserrat', sans-serif;
      transition: border 0.3s ease;
    }

    .form-control:focus {
      outline: none;
      border-color: #d4a574;
    }

    textarea.form-control {
      resize: vertical;
      min-height: 100px;
    }

    /* Gold Badge */
    .gold-badge {
      background: linear-gradient(135deg, #d4af37 0%, #f9d77e 100%);
      color: #000;
      padding: 8px 20px;
      border-radius: 25px;
      font-size: 1rem;
      font-weight: bold;
      display: inline-block;
      margin-bottom: 15px;
    }

    /* Required Field */
    .required-field::after {
      content: " *";
      color: red;
    }

    /* Responsive */
    @media (max-width: 768px) {
      .container {
        padding: 1rem;
      }

      .header-title {
        font-size: 1.5rem;
      }

      .card-title {
        font-size: 1.5rem;
      }
    }
  </style>
</head>

<body>
  <!-- Header -->
  <div class="header">
    <h1 class="header-title">
      <i class="fas fa-heart"></i> On s'est dit OUI !
    </h1>
    <p class="header-subtitle">Confirmez votre invitation</p>
    <p class="header-subtitle">Aaron & Princillia - 20 Décembre 2025</p>
  </div>

  <div class="container">
    <!-- Logo -->
    <div class="text-center mb-1">
      <img src="images/ChatGPT 9'.png" alt="Welcome" style="max-width: 300px;">
    </div>

    <!-- Messages d'erreur -->
    <?php if (!empty($errors)): ?>
      <div class="alert alert-danger">
        <ul class="mb-0" style="list-style: none; padding: 0;">
          <?php foreach ($errors as $error): ?>
            <li><i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($error) ?></li>
          <?php endforeach; ?>
        </ul>
      </div>
    <?php endif; ?>

    <!-- Message de succès -->
    <?php if ($message): ?>
      <div class="alert">
        <i class="fas fa-check-circle"></i> <?= $message ?>
      </div>
      <script>
        // Afficher les confettis après confirmation
        if (document.readyState === 'loading') {
          document.addEventListener('DOMContentLoaded', function() {
            createConfetti();
          });
        } else {
          createConfetti();
        }

        function createConfetti() {
          // Palette de couleurs du mariage : doré, beige, marron clair
          const colors = ['#d4a574', '#8b6f47', '#e7c04d', '#f3d89c', '#c19a6b'];

          for (let i = 0; i < 40; i++) {
            const confetti = document.createElement('div');
            confetti.style.position = 'fixed';
            confetti.style.left = Math.random() * 100 + 'vw';
            confetti.style.top = '-10px';
            confetti.style.width = `${Math.random() * 8 + 6}px`;
            confetti.style.height = `${Math.random() * 8 + 6}px`;
            confetti.style.zIndex = '9999';
            confetti.style.pointerEvents = 'none';
            confetti.style.opacity = '0.9';
            confetti.style.fontSize = '10px';
            confetti.style.fontFamily = "'Playfair Display', 'Great Vibes', serif";
            confetti.style.color = colors[Math.floor(Math.random() * colors.length)];
            confetti.style.display = 'flex';
            confetti.style.alignItems = 'center';
            confetti.style.justifyContent = 'center';
            confetti.style.textAlign = 'center';

            // Alternance subtile entre cœur et "A & P"
            if (Math.random() > 0.5) {
              // Cœur doré, fin et élégant
              confetti.style.clipPath = 'polygon(50% 0%, 61% 35%, 98% 35%, 68% 57%, 79% 91%, 50% 70%, 21% 91%, 32% 57%, 2% 35%, 39% 35%)';
              confetti.style.backgroundColor = colors[Math.floor(Math.random() * colors.length)];
            } else {
              // Texte "A & P" avec police élégante
              confetti.style.backgroundColor = 'transparent';
              confetti.textContent = 'A & P';
              confetti.style.fontWeight = 'normal';
              confetti.style.letterSpacing = '0.5px';
            }

            document.body.appendChild(confetti);

            // Animation douce et naturelle
            const animation = confetti.animate([{
                transform: 'translateY(0) rotate(0deg)',
                opacity: 1
              },
              {
                transform: `translateY(${window.innerHeight}px) rotate(${Math.random() * 720}deg)`,
                opacity: 0
              }
            ], {
              duration: 6000 + Math.random() * 4000,
              easing: 'cubic-bezier(0.2, 0.8, 0.3, 1)',
              delay: Math.random() * 500
            });

            animation.onfinish = () => confetti.remove();
          }
        }
      </script>
    <?php endif; ?>

    <!-- ÉTAPE 1 : Entrer le code d'invitation -->
    <?php if ($step === 'code'): ?>
      <div class="card">
        <h3 class="card-title">Entrez votre code d'invitation</h3>
        <form method="POST">
          <div class="mb-3">
            <label for="code_invitation" class="form-label required-field">Code d'invitation</label>
            <input
              type="text"
              id="code_invitation"
              name="code_invitation"
              class="form-control text-center"
              placeholder="Ex: ABC123"
              required
              autofocus
              style="font-size: 1.2rem; letter-spacing: 3px;" />
            <small style="color: #999; display: block; margin-top: 0.5rem;">Entrez le code reçu avec votre invitation</small>
          </div>
          <button type="submit" name="verify_code" class="btn btn-primary">
            <i class="fas fa-search"></i> Vérifier mon code
          </button>
        </form>
      </div>
    <?php endif; ?>

    <!-- ÉTAPE 2 : Formulaire de confirmation -->
    <?php if ($step === 'form' && $invite): ?>
      <?php
      // Détecter si c'est un couple (insensible à la casse)
      $isCouple = (strtolower($invite['type_invitation']) === 'couple');
      ?>

      <div class="card">
        <div class="text-center mb-4">
          <span class="gold-badge">
            <?= $isCouple ? '👫 Couple invité' : '👤 Invité(e)' ?>
          </span>
        </div>

        <div class="alert">
          <i class="fas fa-check-circle"></i> Invitation trouvée ! Complétez vos informations ci-dessous.
        </div>

        <form method="POST" novalidate>
          <!-- Nom(s) -->
          <?php if ($isCouple): ?>
            <div class="mb-3">
              <label for="nom" class="form-label required-field"><?= htmlspecialchars($invite['titre1'] ?? 'Monsieur') ?></label>
              <input
                type="text"
                id="nom"
                name="nom"
                class="form-control"
                value="<?= htmlspecialchars($invite['nom'] ?? '') ?>"
                placeholder="Nom complet de Monsieur"
                required />
            </div>

            <div class="mb-3">
              <label for="nom2" class="form-label required-field"><?= htmlspecialchars($invite['titre2'] ?? 'Madame') ?></label>
              <input
                type="text"
                id="nom2"
                name="nom2"
                class="form-control"
                value="<?= htmlspecialchars($invite['nom2'] ?? '') ?>"
                placeholder="Nom complet de Madame"
                required />
            </div>
          <?php else: ?>
            <div class="mb-3">
              <label for="nom" class="form-label required-field"><?= htmlspecialchars($invite['titre1'] ?? 'Nom complet') ?></label>
              <input
                type="text"
                id="nom"
                name="nom"
                class="form-control"
                value="<?= htmlspecialchars($invite['nom'] ?? '') ?>"
                placeholder="Votre nom complet"
                required />
            </div>
          <?php endif; ?>

          <!-- Numéro WhatsApp -->
          <div class="mb-3">
            <label for="telephone" class="form-label required-field">
              <i class="fab fa-whatsapp text-success"></i> Numéro WhatsApp
            </label>
            <div style="display: flex; gap: 0.5rem;">
              <select name="country_code" class="form-control" style="flex: 0 0 100px;">
                <option value="243">🇨🇩 +243</option>
                <option value="256">🇺🇬 +256</option>
                <option value="254">🇰🇪 +254</option>
                <option value="255">🇹🇿 +255</option>
                <option value="237">🇨🇲 +237</option>
                <option value="212">🇲🇦 +212</option>
                <option value="33">🇫🇷 +33</option>
              </select>
              <input
                type="tel"
                id="telephone"
                name="telephone"
                class="form-control"
                placeholder="Ex: 812345678"
                required
                style="border-left: 4px solid #25D366; flex: 1;" />
            </div>
            <small style="color: #999; display: block; margin-top: 0.5rem;">
              <i class="fas fa-info-circle"></i> Entrez votre numéro sans le code pays
            </small>
            <small style="color: #999; display: block; margin-top: 0.5rem;">
              <i class="fas fa-info-circle"></i> Formats acceptés: 0812345678, 243812345678 ou +243812345678
            </small>
          </div>

          <!-- Message pour les mariés -->
          <div class="mb-3">
            <label for="message_maries" class="form-label">
              <i class="fas fa-heart"></i> Message pour Aaron & Princillia <small style="color: #999;">(optionnel)</small>
            </label>
            <textarea
              id="message_maries"
              name="message_maries"
              class="form-control"
              rows="3"
              placeholder="Laissez un message de félicitations..."
              maxlength="500"></textarea>
            <small style="color: #999; display: block; margin-top: 0.5rem;">Maximum 500 caractères</small>
          </div>

          <button type="submit" name="confirm_invitation" class="btn btn-success">
            <i class="fas fa-check-circle"></i> Confirmer et générer mon invitation
          </button>
        </form>
      </div>
    <?php endif; ?>

    <!-- ÉTAPE 3 : Succès - Afficher QR code et PDF -->
    <?php if ($step === 'success' && $invite): ?>
      <?php
      $isCouple = (strtolower($invite['type_invitation']) === 'couple');
      $publicQrUrl = "https://vkiz-digital.website/aaronandprincillia/" . $qrCodePath;
      $publicPdfUrl = "https://vkiz-digital.website/aaronandprincillia/" . $invite['pdf_file'];

      $whatsappMessage = urlencode("Voici votre invitation au mariage d'Aaron & Princillia le 20 Décembre 2025 : $publicPdfUrl");
      $whatsappLink = "https://wa.me/" . $invite['telephone'] . "?text=$whatsappMessage";
      ?>

      <div class="card text-center">
        <div class="mb-4">
          <i class="fas fa-check-circle text-success" style="font-size: 4rem;"></i>
          <h3 style="font-family: 'Playfair Display', serif; margin-top: 1rem;">Confirmation réussie !</h3>
          <p style="color: #666; margin: 0.5rem 0;">
            Bienvenue <?= $isCouple ? "M. & Mme " . htmlspecialchars($invite['nom']) : htmlspecialchars($invite['titre1']) . " " . htmlspecialchars($invite['nom']) ?> !
          </p>
        </div>

        <!-- Aperçu du QR Code -->
        <div class="mb-4">
          <img src="<?= htmlspecialchars($qrCodePath) ?>" alt="QR Code" style="max-width: 250px; border: 3px solid #d4af37; border-radius: 10px;">
        </div>

        <div class="alert alert-info">
          <i class="fas fa-info-circle"></i> Présentez votre invitation à l'entrée de la salle
        </div>

        <!-- Boutons d'action -->
        <div style="display: flex; flex-direction: column; gap: 1rem;">
          <a href="<?= htmlspecialchars($whatsappLink) ?>" target="_blank" class="btn btn-success-whatsapp">
            <i class="fab fa-whatsapp"></i> Recevoir mon invitation sur WhatsApp
          </a>

          <a href="<?= htmlspecialchars($invite['pdf_file']) ?>" download="Invitation_Mariage_Aaron_Princillia.pdf" class="btn btn-outline-primary" onclick="downloadAndReset(event)">
            <i class="fas fa-download"></i> Télécharger mon invitation (PDF)
          </a>
            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
            <script>
            // Initialisations utiles (tooltips, popovers, etc.)
            document.addEventListener('DOMContentLoaded', function () {
              // Tooltips
              document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(function (el) {
              new bootstrap.Tooltip(el);
              });
              // Popovers (si utilisés)
              document.querySelectorAll('[data-bs-toggle="popover"]').forEach(function (el) {
              new bootstrap.Popover(el);
              });
            });
            </script>
          <script>
            function downloadAndReset(event) {
              event.preventDefault();

              // Télécharger le fichier
              const link = document.createElement('a');
              link.href = event.target.href;
              link.download = 'Invitation_Mariage_Aaron_Princillia.pdf';
              document.body.appendChild(link);
              link.click();
              document.body.removeChild(link);

              // Attendre 2 secondes puis rediriger
              setTimeout(() => {
                window.location.href = 'index.php';
              }, 2000);
            }
          </script>
        </div>

        <div style="margin-top: 1.5rem; color: #999; font-size: 0.9rem;">
          <i class="fas fa-calendar-alt"></i> Rendez-vous le 20 Décembre 2025 à 18h00<br>
          <span style="color: #d4a574;">Au plaisir de vous voir ! 💝</span>
        </div>
      </div>
    <?php endif; ?>

    <!-- ÉTAPE : Déjà confirmé -->
    <?php if ($step === 'already_confirmed' && $invite): ?>
      <?php
      $isCouple = (strtolower($invite['type_invitation']) === 'couple');
      $publicPdfUrl = "https://vkiz-digital.website/aaronandprincillia/invitations_pdf/" . ($invite['pdf_file'] ?? '');

      $whatsappMessage = urlencode("Voici votre invitation au mariage d'Aaron & Princillia le 20 Décembre 2025.\n\nVeuillez cliquer : $publicPdfUrl");
      $whatsappLink = "https://wa.me/" . $invite['telephone'] . "?text=$whatsappMessage";
      ?>

      <div class="card text-center">
        <div class="mb-4">
          <i class="fas fa-info-circle text-primary" style="font-size: 4rem;"></i>
          <h3 style="font-family: 'Playfair Display', serif; margin-top: 1rem;">Invitation déjà confirmée</h3>
          <p style="color: #666; margin: 0.5rem 0;">
            <?= $isCouple ? "Couple : M. & Mme " . htmlspecialchars($invite['nom']) : htmlspecialchars($invite['titre1']) . " " . htmlspecialchars($invite['nom']) ?>
          </p>
        </div>

        <?php if ($qrCodePath && file_exists($qrCodePath)): ?>
          <div class="mb-4">
            <img src="<?= htmlspecialchars($qrCodePath) ?>" alt="QR Code" style="max-width: 250px; border: 3px solid #d4af37; border-radius: 10px;">
          </div>
        <?php endif; ?>

        <div class="alert alert-info">
          <i class="fas fa-info-circle"></i> Votre invitation a déjà été générée
        </div>

        <div style="display: flex; flex-direction: column; gap: 1rem;">
          <a href="<?= htmlspecialchars($whatsappLink) ?>" target="_blank" class="btn btn-success-whatsapp">
            <i class="fab fa-whatsapp"></i> Renvoyer sur WhatsApp
          </a>

          <?php if (!empty($invite['pdf_file']) && file_exists($invite['pdf_file'])): ?>
            <a href="<?= htmlspecialchars($invite['pdf_file']) ?>" download="Invitation_Mariage_Aaron_Princillia.pdf" class="btn btn-outline-primary">
              <i class="fas fa-download"></i> Télécharger mon invitation
            </a>
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>

  </div>
</body>

</html>