<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Détails de l'événement - Gala de Charité 2025</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />

  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.13.1/font/bootstrap-icons.css" rel="stylesheet" />

  <!-- CSS personnalisé -->
  <link rel="stylesheet" href="css/details.css" />
</head>
<body>

  <!-- Navbar Bootstrap -->
  <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm sticky-top">
    <div class="container mb-0 mt-0 pt-0 pb-0">
      <a class="navbar-brand fw-bold pt-0 pb-0 mb-0 mt-0" href="index.php">
        <img src="images/logo.ico" alt="Logo" class="logo" width="100px" />
      </a>
      <button
        class="navbar-toggler"
        type="button"
        data-bs-toggle="collapse"
        data-bs-target="#navbarNav"
        aria-controls="navbarNav"
        aria-expanded="false"
        aria-label="Toggle navigation"
      >
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
        <ul class="navbar-nav fw-semibold">
          <li class="nav-item">
            <a class="nav-link" href="#">Accueil</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#">Événements</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#">Contact</a>
          </li>
        </ul>
      </div>
    </div>
  </nav>

  <header class="bg-primary text-white py-5 text-center shadow-sm">
    <div class="container">
      <h1 class="display-4 fw-bold">Mariage Religieux 2026</h1>
      <p class="lead fst-italic">Une soirée inoubliable pour une cause noble</p>
    </div>
  </header>

  <main class="container my-5" style="max-width: 900px;">

    <!-- Détails -->
    <section class="mb-5">
      <div class="row justify-content-center text-center text-md-start align-items-center">
        <div class="col-md-6 mb-4 mb-md-0">
          <img src="https://images.unsplash.com/photo-1506744038136-46273834b3fb?auto=format&fit=crop&w=700&q=80" alt="Événement Gala" class="img-fluid rounded shadow" />
        </div>
        <div class="col-md-6">
          <h2 class="mb-4 text-primary fw-semibold"><i class="bi bi-calendar-event me-2"></i>Bénédiction Nuptiale</h2>
          <ul class="list-unstyled fs-5 mx-auto" style="max-width: 320px;">
            <li class="mb-3"><i class="bi bi-calendar3-fill text-primary me-2"></i><strong></strong> 12 septembre 2025</li>
            <li class="mb-3"><i class="bi bi-geo-alt-fill text-primary me-2"></i><strong></strong> Centre Evangelique la borne, Kinshasa <br> 10e Rue Kasavubu</li>
            <li class="mb-3"><i class="bi bi-clock-fill text-primary me-2"></i><strong></strong> 19h00 - 23h00</li>
          </ul>
        </div>
      </div>
    </section>

    <!-- Dress Code & Infos -->
    <section class="mb-5 bg-light p-4 rounded shadow-sm text-center">
      <h2 class="text-primary fw-semibold mb-4"><i class="bi bi-person-standing me-0"></i><i class="bi bi-person-standing-dress me-2"></i>Dress Code & Infos pratiques</h2>
      <p class="fs-5 mb-3"><strong>Dress Code :</strong> Tenue de soirée élégante</p>
      <p class="fs-6 mb-0">Merci car votre presence est deja precieuse.</p>
    </section>

    <section class="mb-5 bg-light p-4 rounded-5 shadow-sm text-center">
      <h2 class="text-primary fw-semibold mb-4 text-center"><i class="bi bi-gift-fill me-2"></i>Mariage Réligieux</h2>
          <a href="essaye_confirm_invit.php">
            <button
              type="button"
              class="btn btn-primary neu-btn">
              Télécharger l'invitation PDF
            </button>
          </a>
          
    </section>

    <!-- Carte Google Maps -->
    <section class="mb-5">
      <h2 class="text-primary fw-semibold mb-4 text-center"><i class="bi bi-map-fill me-2"></i>Localisation</h2>
      <div id="map" class="rounded shadow mx-auto" style="max-width: 700px;"></div>
    </section>

    <!-- FAQ accordéon Bootstrap -->
    <section class="mb-5" style="max-width: 700px; margin: 0 auto;">
      <h2 class="text-primary fw-semibold mb-4 text-center"><i class="bi bi-question-circle-fill me-2"></i>FAQ</h2>
      <div class="accordion" id="faqAccordion">

        <div class="accordion-item">
          <h3 class="accordion-header" id="headingOne">
            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
              Y a-t-il un parking disponible ?
            </button>
          </h3>
          <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#faqAccordion">
            <div class="accordion-body">
              Oui, un parking public est situé à 200 mètres du centre culturel, accessible via la rue des Lilas.
            </div>
          </div>
        </div>

        <div class="accordion-item">
          <h3 class="accordion-header" id="headingTwo">
            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
              Les enfants sont-ils acceptés ?
            </button>
          </h3>
          <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#faqAccordion">
            <div class="accordion-body">
              L'événement est réservé aux personnes âgées de plus de 18 ans.
            </div>
          </div>
        </div>

        <div class="accordion-item">
          <h3 class="accordion-header" id="headingThree">
            <button class="accordion-button collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
              Quelles sont les mesures de sécurité ?
            </button>
          </h3>
          <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#faqAccordion">
            <div class="accordion-body">
              Un contrôle à l’entrée est prévu, merci de vous munir de votre invitation.
            </div>
          </div>
        </div>

      </div>
    </section>

  </main>

  <footer class="bg-primary text-white text-center py-4">
    &copy; 2025 Gala de Charité - Tous droits réservés
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Google Maps -->
  <script>
    function initMap() {
      const location = { lat: -33.97928331515799, lng: 18.598182622618744 }; // captown
      const map = new google.maps.Map(document.getElementById("map"), {
        zoom: 14,
        center: location,
        disableDefaultUI: true,
        zoomControl: true,
      });
      new google.maps.Marker({
        position: location,
        map: map,
        title: "Centre culturel Lumière",
      });
    }
  </script>
  <script async
    src="https://maps.googleapis.com/maps/api/js?key=TA_CLE_API&callback=initMap">
  </script>

</body>
</html>
