<?php
session_start();

try {
  $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  ]);
} catch (Exception $e) {
  die("Erreur DB : " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Scanner QR - Check-in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/jsqr@1.4.0/dist/jsQR.js"></script>
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: white;
            text-align: center;
        }
        .container {
            background: rgba(255,255,255,0.1);
            padding: 30px;
            border-radius: 15px;
            max-width: 500px;
            width: 100%;
        }
        .btn-lg {
            padding: 15px 30px;
            font-size: 1.2rem;
        }
        #status {
            margin-top: 20px;
            font-size: 1.1rem;
            color: #ffcc00;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><i class="fas fa-qrcode"></i> Scanner QR</h1>
        <p>Appuyez sur le bouton ci-dessous pour ouvrir la caméra.</p>

        <button class="btn btn-success btn-lg" onclick="startScanner()">
            <i class="fas fa-camera"></i> Ouvrir la caméra
        </button>

        <div id="status">Prêt à scanner...</div>
    </div>

    <!-- Caméra cachée -->
    <video id="video" playsinline style="display: none;"></video>
    <canvas id="canvas" style="display: none;"></canvas>

    <script>
        let stream = null;

        function startScanner() {
            const video = document.getElementById('video');
            const status = document.getElementById('status');

            navigator.mediaDevices.getUserMedia({ video: { facingMode: 'environment' } })
                .then(s => {
                    stream = s;
                    video.srcObject = stream;
                    video.play();
                    status.textContent = 'Scannez un QR code...';
                    scanQR();
                })
                .catch(err => {
                    status.textContent = 'Erreur : ' + err.message;
                    alert('Impossible d\'accéder à la caméra. Vérifiez les permissions.');
                });
        }

        function scanQR() {
            const video = document.getElementById('video');
            const canvas = document.getElementById('canvas');
            const ctx = canvas.getContext('2d');

            if (video.readyState === video.HAVE_ENOUGH_DATA) {
                canvas.width = video.videoWidth;
                canvas.height = video.videoHeight;
                ctx.drawImage(video, 0, 0);

                const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
                const code = jsQR(imageData.data, imageData.width, imageData.height);

                if (code) {
                    // Extrait l'ID de l'URL
                    const url = new URL(code.data);
                    const id = url.searchParams.get('id');

                    if (id) {
                        window.location.href = `verify_invite.php?id=${id}`;
                    } else {
                        document.getElementById('status').textContent = 'QR code invalide (pas d\'ID)';
                    }
                    return;
                }
            }
            requestAnimationFrame(scanQR);
        }
    </script>
</body>
</html>