<?php
session_start();

// Optionnel : sécuriser l’accès
// if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
//     http_response_code(403);
//     exit('Accès refusé.');
// }

try {
    $pdo = new PDO(
        "mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4",
        'tostrlgj_voldy',
        'Voldy25@Ilus',
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
} catch (PDOException $e) {
    echo '<tr><td colspan="8" class="text-center text-danger py-4">❌ Erreur de base de données.</td></tr>';
    exit;
}

$search = trim($_GET['q'] ?? '');
$params = [];
$sql = "SELECT * FROM invites";

if ($search !== '') {
    $sql .= " WHERE nom LIKE ? OR email LIKE ? OR telephone LIKE ? OR code_invitation LIKE ? OR nom2 LIKE ?";
    $like = "%{$search}%";
    $params = [$like, $like, $like, $like, $like];
}

$sql .= " ORDER BY date_created DESC LIMIT 100";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

if (empty($rows)) {
    echo '
    <tr>
        <td colspan="8" class="text-center py-5">
            <div class="mb-3">
                <img src="../images/undraw_feeling-blue_8si6.png" alt="Aucun résultat" class="img-fluid" style="max-width: 220px; opacity: 0.8;">
            </div>
            <p class="text-muted mb-0" style="font-size: 1.1rem;">
                Aucun invité trouvé pour "<strong>' . htmlspecialchars($search) . '</strong>"
            </p>
        </td>
    </tr>';
    exit;
}

foreach ($rows as $inv) {
    // Déterminer la classe de fond pour la colonne "Type"
    $type = $inv['type_invitation'] ?? 'inconnu';
    $typeLabel = match($type) {
        'couple' => 'Invitation Couple',
        'famille' => 'Invitation Famille',
        default => 'Invitation Individuelle'
    };

    $bgClass = match($type) {
        'couple' => 'bg-success',
        'famille' => 'bg-warning',
        default => 'bg-info'
    };

    // Couleur du texte pour contraste (blanc sur tous les fonds)
    $textClass = 'text-white';

    // Confirmation status
    $confirmed = !empty($inv['status']) && $inv['status'] === 'A confirmé';
    ?>
    <tr>
        <!-- Type d'invitation → cellule entière colorée -->
        <td class="<?= $bgClass ?> <?= $textClass ?>" style="font-weight: 500; width: 180px;">
            <?= htmlspecialchars($typeLabel) ?>
        </td>

        <!-- Nom(s) -->
        <td>
            <?= htmlspecialchars($inv['titre1'] . ' ' . $inv['nom']) ?>
            <?php if ($type === 'couple' && !empty($inv['nom2'])): ?>
                <br><small class="text-muted">+ <?= htmlspecialchars($inv['titre2'] . ' ' . $inv['nom2']) ?></small>
            <?php endif; ?>
        </td>

        <!-- Email -->
        <td><?= htmlspecialchars($inv['email'] ?? '') ?></td>

        <!-- Téléphone -->
        <td><?= htmlspecialchars($inv['telephone'] ?? '') ?></td>

        <!-- Code d'invitation -->
        <td class="fw-bold"><?= htmlspecialchars($inv['code_invitation'] ?? '') ?></td>

        <!-- Numéro de table -->
        <td><?= !empty($inv['table_num']) ? htmlspecialchars($inv['table_num']) : '<span class="text-muted">—</span>' ?></td>

        <!-- Statut de confirmation -->
        <td>
            <?php if ($confirmed): ?>
                <span class="badge bg-success">✅ Confirmé</span>
            <?php else: ?>
                <span class="badge bg-secondary">🕒 En attente</span>
            <?php endif; ?>
        </td>

        <!-- Date -->
        <td><?= htmlspecialchars($inv['date_created'] ?? '') ?></td>
    </tr>
    <?php
}
?>