<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

if (empty($_SESSION['whatsapp_bulk_ids'])) {
    header('Location: admin_dashboard.php');
    exit;
}

$ids = array_map('intval', $_SESSION['whatsapp_bulk_ids']);
unset($_SESSION['whatsapp_bulk_ids']); // Nettoyage

try {
    $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (Exception $e) {
    die("Erreur base de données.");
}

$placeholders = str_repeat('?,', count($ids) - 1) . '?';
$stmt = $pdo->prepare("SELECT nom, telephone, code_invitation, titre1 FROM invites WHERE id IN ($placeholders) AND telephone IS NOT NULL AND telephone != ''");
$stmt->execute($ids);
$invites = $stmt->fetchAll();

if (empty($invites)) {
    die("Aucun invité avec numéro de téléphone valide.");
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>📲 WhatsApp Bulk</title>
  <meta charset="UTF-8">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f0f9ff;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      margin: 0;
    }
    .container {
      text-align: center;
      background: white;
      padding: 2rem;
      border-radius: 15px;
      box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    }
    .progress {
      margin-top: 1rem;
      font-size: 0.9rem;
      color: #555;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2> WhatsApp en cours…</h2>
    <p>Ouverture de <?= count($invites) ?> conversations WhatsApp…</p>
    <div class="progress" id="progress">Préparation…</div>
  </div>

  <script>
    // Données des invités
    const invites = <?= json_encode($invites) ?>;

    // Fonction pour nettoyer le téléphone
    function cleanPhone(phone) {
      return phone.replace(/\D/g, '');
    }

    // Délai entre chaque ouverture (en ms)
    const delay = 2500;

    // Ouvrir les onglets un par un
    invites.forEach((inv, index) => {
      setTimeout(() => {
        const phone = cleanPhone(inv.telephone);
        const name = (inv.titre1 || '') + ' ' + inv.nom;
        const code = inv.code_invitation;

        const message = `Bonjour ${name},

Nous avons le plaisir de vous inviter à notre *Mariage Coutumier*, qui aura lieu le 20 Décembre 2025.

Votre code d'invitation : *${code}*

Veuillez confirmer votre présence ici :
https://vkiz-digital.website/aaronandprincillia/essaye_confirm_invit.php?code=${code}

Au plaisir de vous y voir !
Aaron & Princillia`;

        const url = `https://wa.me/${phone}?text=${encodeURIComponent(message)}`;
        window.open(url, '_blank');

        // Mise à jour du statut
        document.getElementById('progress').textContent = 
          `Ouvert : ${index + 1} / ${invites.length} — Envoi à ${name}`;
      }, index * delay);
    });

    // Redirection automatique après
    setTimeout(() => {
      window.location.href = 'admin_dashboard.php';
    }, invites.length * delay + 5000);
  </script>
</body>
</html>