<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

try {
    $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (Exception $e) {
    die("Erreur base de données.");
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>📊 Statistiques - Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700;900&family=Lora:wght@400;500;600&family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Lora', serif;
            color: #2c2c2c;
            background: #fafaf8;
            overflow-x: hidden;
        }
        .navbar {
            position: fixed;
            top: 0;
            width: 100%;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 1rem 2rem;
            z-index: 1000;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.05);
        }
        .logo-text {
            font-family: 'Playfair Display', serif;
            font-size: 1.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .container {
            margin-top: 100px;
            padding: 2rem;
        }
        .section-title {
            font-family: 'Playfair Display', serif;
            font-size: 2.5rem;
            text-align: center;
            margin-bottom: 2.5rem;
            color: #2c2c2c;
            position: relative;
        }
        .section-title::after {
            content: '';
            position: absolute;
            width: 60px;
            height: 3px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            left: 50%;
            transform: translateX(-50%);
            bottom: -10px;
        }
        .stat-card {
            background: white;
            border-radius: 15px;
            padding: 1.8rem;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            transition: transform 0.3s ease;
            border-top: 4px solid #d4a574;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .stat-number {
            font-family: 'Playfair Display', serif;
            font-size: 2.8rem;
            font-weight: 900;
            color: #d4a574;
            margin: 0.5rem 0;
        }
        .stat-label {
            font-family: 'Montserrat', sans-serif;
            font-size: 1rem;
            color: #555;
            font-weight: 500;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 1.8rem;
            margin-bottom: 3rem;
        }
        .chart-container {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
            margin-top: 2rem;
        }
        .chart-title {
            font-family: 'Playfair Display', serif;
            font-size: 1.8rem;
            margin-bottom: 1.5rem;
            color: #2c2c2c;
        }
        .back-link {
            display: inline-block;
            margin-bottom: 1.5rem;
            color: #d4a574;
            text-decoration: none;
            font-weight: 600;
        }
        .back-link:hover {
            text-decoration: underline;
        }
        .progress {
            height: 12px;
            border-radius: 6px;
            background-color: #f0f0f0;
        }
        .progress-bar {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
        }
        table img {
            max-width: 40px;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="logo-text">A & P • Admin</div>
    </nav>

    <div class="container">
        <a href="admin_dashboard.php" class="back-link">
            <i class="fas fa-arrow-left"></i> Retour au tableau de bord
        </a>

        <h2 class="section-title">📊 Statistiques des Invités</h2>

        <?php
        // Récupérer les stats
        $total = $pdo->query("SELECT COUNT(*) FROM invites")->fetchColumn();
        $confirmed = $pdo->query("SELECT COUNT(*) FROM invites WHERE status = 'A confirmé'")->fetchColumn();
        $notConfirmed = $total - $confirmed;
        $single = $pdo->query("SELECT COUNT(*) FROM invites WHERE type_invitation = 'single'")->fetchColumn();
        $couple = $pdo->query("SELECT COUNT(*) FROM invites WHERE type_invitation = 'couple'")->fetchColumn();
//        $family = $pdo->query("SELECT COUNT(*) FROM invites WHERE type_invitation = 'famille'")->fetchColumn();
        $responseRate = $total > 0 ? round(($confirmed / $total) * 100, 1) : 0;
        ?>

        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number"><?= $total ?></div>
                <div class="stat-label">Invités totaux</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $confirmed ?></div>
                <div class="stat-label">✅ Confirmés</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $notConfirmed ?></div>
                <div class="stat-label">⏳ En attente / Non venus</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $single ?></div>
                <div class="stat-label">👤 Célibataires</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?= $couple ?></div>
                <div class="stat-label">💑 Couples</div>
            </div>
<!--             <div class="stat-card">
                <div class="stat-number"><?= $family ?></div>
                <div class="stat-label">👨‍👩‍👧‍👦 Familles</div> -->
            </div>
        </div>

        <!-- Taux de réponse -->
        <div class="chart-container">
            <h3 class="chart-title">Taux de réponse</h3>
            <div class="d-flex align-items-center mb-2">
                <span class="me-3"><?= $responseRate ?>%</span>
                <div class="flex-grow-1">
                    <div class="progress">
                        <div class="progress-bar" role="progressbar" style="width: <?= min($responseRate, 100) ?>%;"></div>
                    </div>
                </div>
            </div>
            <small class="text-muted"><?= $confirmed ?> sur <?= $total ?> ont confirmé</small>
        </div>

        <!-- Recherche -->
        <div class="chart-container mt-4">
            <h3 class="chart-title">🔍 Rechercher un invité</h3>
            <input type="text" id="searchInput" class="form-control mb-3" placeholder="Nom, email, téléphone, code...">
            <div id="searchResults"></div>
        </div>
    </div>

    <script>
        document.getElementById('searchInput').addEventListener('input', function() {
            const q = this.value.trim();
            const resultsDiv = document.getElementById('searchResults');
            if (q.length < 2) {
                resultsDiv.innerHTML = '';
                return;
            }

            fetch('dashboard_search_invit.php?q=' + encodeURIComponent(q))
                .then(response => response.text())
                .then(html => {
                    if (html.trim()) {
                        resultsDiv.innerHTML = `<table class="table table-hover">${html}</table>`;
                    } else {
                        resultsDiv.innerHTML = '<div class="text-center text-muted mt-3">Aucun résultat</div>';
                    }
                })
                .catch(() => {
                    resultsDiv.innerHTML = '<div class="text-danger">Erreur lors de la recherche</div>';
                });
        });
    </script>
</body>
</html>