<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

try {
    $pdo = new PDO("mysql:host=localhost;dbname=tostrlgj_mariage_db;charset=utf8mb4", 'tostrlgj_voldy', 'Voldy25@Ilus', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (Exception $e) {
    die("Erreur base de données.");
}

$message = '';

// Enregistrer les modifications
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $address = trim($_POST['address'] ?? '');
    $schedule = trim($_POST['schedule'] ?? '');
    $contact = trim($_POST['contact'] ?? '');
    $map_link = trim($_POST['map_link'] ?? '');
    $latitude = trim($_POST['latitude'] ?? '');
    $longitude = trim($_POST['longitude'] ?? '');
    $map_iframe = trim($_POST['map_iframe'] ?? '');

    $stmt = $pdo->prepare("UPDATE wedding_location SET address = ?, schedule = ?, contact = ?, map_link = ?, map_iframe = ?, latitude = ?, longitude = ? WHERE id = 1");
    $stmt->execute([$address, $schedule, $contact, $map_link, $map_iframe, $latitude, $longitude]);
    $message = '✅ Informations mises à jour avec succès !';
}
?>

<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <title>📍 Gestion du Lieu</title>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700;900&family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Montserrat', sans-serif;
            background: linear-gradient(135deg, #f5f5f2 0%, #e8e6e1 100%);
            padding: 2rem;
            color: #2c2c2c;
        }

        .container {
            max-width: 900px;
            margin: 0 auto;
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: #d4a574;
            text-decoration: none;
            font-weight: 600;
            margin-bottom: 2rem;
        }

        .header {
            text-align: center;
            margin-bottom: 2rem;
        }

        .header h1 {
            font-family: 'Playfair Display', serif;
            font-size: 2.2rem;
            color: #d4a574;
        }

        .form-card {
            background: white;
            padding: 2rem;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #2c2c2c;
        }

        .form-control,
        .form-control-sm {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 0.75rem;
            font-family: 'Montserrat', sans-serif;
        }

        .btn-save {
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .btn-save:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(212, 165, 116, 0.3);
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }

        .alert-success {
            background: #d4f1d4;
            color: #155724;
            border-left: 4px solid #28a745;
        }
    </style>
</head>

<body>
    <div class="container">
        <a href="admin_dashboard.php" class="back-button">
            <i class="fas fa-arrow-left"></i> Retour au Dashboard
        </a>

        <div class="header">
            <h1>📍 Gestion du Lieu de Cérémonie</h1>
        </div>

        <?php if ($message): ?>
            <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <?php
        $loc = $pdo->query("SELECT * FROM wedding_location WHERE id = 1")->fetch();
        if (!$loc) {
            die("Erreur : aucune donnée de lieu trouvée.");
        }
        ?>

        <div class="form-card">
            <form method="POST">
                <div class="form-group">
                    <label>📍 Adresse</label>
                    <textarea name="address" class="form-control" rows="3"><?= htmlspecialchars($loc['address']) ?></textarea>
                </div>
                <div class="form-group">
                    <label>🕐 Horaire</label>
                    <textarea name="schedule" class="form-control" rows="2"><?= htmlspecialchars($loc['schedule']) ?></textarea>
                </div>
                <div class="form-group">
                    <label>📞 Contact</label>
                    <textarea name="contact" class="form-control" rows="2"><?= htmlspecialchars($loc['contact']) ?></textarea>
                </div>
                <div class="form-group">
                    <label>🔗 Lien court Google Maps (pour le bouton "Itinéraire")</label>
                    <input type="text" name="map_link" class="form-control" value="<?= htmlspecialchars($loc['map_link'] ?? '') ?>" placeholder="https://maps.app.goo.gl/Abc123">
                    <small class="text-muted">Obtenu via Google Maps → clic droit sur le lieu → Partager → Créer un lien court</small>
                </div>
                <div class="form-group">
                    <label>🗺️ Code iframe Google Maps (coller le code embed)</label>
                    <textarea name="map_iframe" class="form-control" rows="5"><?= htmlspecialchars($loc['map_iframe']) ?></textarea>
                    <small class="text-muted">Conseil : dans Google Maps, clic droit → "Partager" → "Intégrer une carte"</small>
                </div>
                <div class="form-group">
                    <label>Latitude</label>
                    <input type="text" name="latitude" value="<?= htmlspecialchars($loc['latitude'] ?? '') ?>">
                </div>
                <div class="form-group">
                    <label>Longitude</label>
                    <input type="text" name="longitude" value="<?= htmlspecialchars($loc['longitude'] ?? '') ?>">
                </div>
                <button type="submit" class="btn-save">
                    <i class="fas fa-save"></i> Enregistrer les modifications
                </button>
            </form>
        </div>
    </div>
</body>

</html>